/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.util.security;

import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Enumeration;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class RSAUtils {
    public static byte[] sha1X16(String data, String encoding) {
        byte[] bytes = RSAUtils.sha1(data, encoding);
        StringBuilder sha1StrBuff = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            if (Integer.toHexString(0xFF & bytes[i]).length() == 1) {
                sha1StrBuff.append("0").append(Integer.toHexString(0xFF & bytes[i]));
                continue;
            }
            sha1StrBuff.append(Integer.toHexString(0xFF & bytes[i]));
        }
        try {
            return sha1StrBuff.toString().getBytes(encoding);
        }
        catch (UnsupportedEncodingException var5) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u54c8\u5e0c\u83b7\u53d6\u5931\u8d25\u3002", (String)"RSAUtils_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), (Throwable)var5);
        }
    }

    public static byte[] sha1(String datas, String encoding) {
        try {
            return RSAUtils.sha1(datas.getBytes(encoding));
        }
        catch (UnsupportedEncodingException var3) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u54c8\u5e0c\u83b7\u53d6\u5931\u8d25\u3002", (String)"RSAUtils_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), (Throwable)var3);
        }
    }

    public static byte[] sha1(byte[] data) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
            md.reset();
            md.update(data);
            return md.digest();
        }
        catch (Exception var3) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u62a5\u6587\u54c8\u5e0c\u83b7\u53d6\u5931\u8d25\u3002", (String)"RSAUtils_0", (String)"ebg-aqap-banks-gdb-opb", (Object[])new Object[0]), (Throwable)var3);
        }
    }

    public static PrivateKey getSignCertPrivateKey(KeyStore keyStore, String password) {
        try {
            Enumeration<String> aliasenum = keyStore.aliases();
            String keyAlias = null;
            if (aliasenum.hasMoreElements()) {
                keyAlias = aliasenum.nextElement();
            }
            return (PrivateKey)keyStore.getKey(keyAlias, password.toCharArray());
        }
        catch (Exception var4) {
            throw EBExceiptionUtil.serviceException((Throwable)var4);
        }
    }

    public static byte[] signBySoft(PrivateKey privateKey, byte[] data) throws Exception {
        Signature st = Signature.getInstance("SHA1withRSA", "BC");
        st.initSign(privateKey);
        st.update(data);
        byte[] result = st.sign();
        return result;
    }
}

