/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gyb.dc.detail;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gyb.dc.helper.GYB_Packer;
import kd.ebg.aqap.banks.gyb.dc.helper.GYB_Parser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);
    int pageSize = 20;
    private final String TRANCODE = "B2eQueryActDetail4UTF8";

    public void configFactory(ConnectionFactory factory) {
        String s = "/New_B2E/Forward.do?SIGDATA=1&";
        try {
            s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("userCif");
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7528\u6237\u5bc6\u7801\u5f02\u5e38", (Throwable)e);
        }
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "simon_wx";
    }

    public String getBizCode() {
        return "B2eQueryAccountDetail4UTF8";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        return this.packDetail(bankDetailRequest);
    }

    public String packDetail(BankDetailRequest request) {
        Element ebank_root = new Element("transaction");
        String accNo = request.getAcnt().getAccNo();
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)accNo))) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8d35\u9633\u94f6\u884c\u4e0d\u652f\u6301\u5b9a\u671f\u8d26\u6237\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\uff0c\u8d26\u53f7\uff1a%1$s\uff0c\u8d26\u53f7\u7c7b\u578b\uff1a%2$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]), accNo, BankAcntPropertyConfig.getAccType((String)accNo)));
        }
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        JDomUtils.addChild((Element)ebank_root, (Element)GYB_Packer.buildHead("B2eQueryActDetail4UTF8", Sequence.gen18Sequence()));
        JDomUtils.addChild((Element)ebank_root, (Element)this.getDetailRequestBody(request, currentPage, this.pageSize + ""));
        String rqstStr = JDomUtils.root2String((Element)ebank_root, (String)RequestContextUtils.getCharset());
        this.logger.info("\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u8bf7\u6c42\u62a5\u6587\uff0c\u5185\u5bb9\uff1a" + rqstStr);
        return rqstStr;
    }

    private Element getDetailRequestBody(BankDetailRequest request, String pageTag, String page) {
        Element RequestBody = new Element("RequestBody");
        Element body = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)body, (String)"AcctNo", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"BeginDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)body, (String)"QueryNo", (String)page);
        JDomUtils.addChild((Element)body, (String)"PageNo", (String)pageTag);
        JDomUtils.addChild((Element)body, (String)"BeginMoney", (String)"");
        JDomUtils.addChild((Element)body, (String)"EndMoney", (String)"");
        this.logger.info("\u660e\u7ec6\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4" + LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        this.logger.info("\u660e\u7ec6\u67e5\u8be2\u7ed3\u675f\u65f6\u95f4" + LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        return RequestBody;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        return new EBBankDetailResponse(this.parseDetail(bankDetailRequest, s));
    }

    public List<DetailInfo> parseDetail(BankDetailRequest arg0, String arg1) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>();
        BankAcnt acnt = arg0.getAcnt();
        String encoding = RequestContextUtils.getCharset();
        Element ebenk = JDomUtils.string2Root((String)arg1, (String)encoding);
        BankResponse bankResponse = GYB_Parser.parserCommonInfo(ebenk);
        this.setLastPage(this.isLastPage(arg1));
        this.setCurrentPage(Integer.parseInt(this.getCurrentPage()) + 1);
        Element head = ebenk.getChild("RespondHeader");
        Element body = ebenk.getChild("RespondBody");
        if ("RET2003".equals(bankResponse.getResponseCode())) {
            return detailList;
        }
        if ("0000".equals(bankResponse.getResponseCode()) || "RET2000".equals(bankResponse.getResponseCode())) {
            List list = body.getChildren("RespondRecord");
            if (list.size() == 0) {
                return detailList;
            }
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)1);
            for (int i = 0; i < list.size(); ++i) {
                DetailInfo detail = new DetailInfo();
                Element row = (Element)list.get(i);
                detail.setCurrency("CNY");
                String acctNo = row.getChildTextTrim("AcctNo2");
                String accountName = row.getChildTextTrim("Acct2Name");
                String accountOpenNode = row.getChildTextTrim("Acct2BankName");
                String HostJournalNo = row.getChildTextTrim("HostJournalNo");
                detail.setAccNo(acnt.getAccNo());
                detail.setAccName(acnt.getAccName());
                detail.setBankName(acnt.getBankName());
                detail.setOppAccNo(acctNo);
                detail.setOppAccName(accountName);
                detail.setOppBankName(accountOpenNode);
                String transferDate = row.getChildTextTrim("HostTxnDate");
                String transferTime = row.getChildTextTrim("TrsTime");
                LocalDateTime transTime = LocalDateTime.parse(transferDate + " " + transferTime, DateTimeFormatter.ofPattern("yyyyMMdd HHmmss"));
                detail.setTransTime(transTime);
                detail.setTransDate(LocalDateUtil.parserDate((String)transferDate, (String)"yyyyMMdd"));
                String payAmount = row.getChildTextTrim("Amount");
                String recAmount = row.getChildTextTrim("Amount");
                BigDecimal payAmountD = new BigDecimal(payAmount);
                BigDecimal recAmountD = new BigDecimal(recAmount);
                String CDFlag = row.getChildTextTrim("CrDtIndicator");
                if (CDFlag.equalsIgnoreCase("0")) {
                    detail.setDebitAmount(payAmountD);
                    detail.setCreditAmount(new BigDecimal("0.00"));
                } else if (CDFlag.equalsIgnoreCase("1")) {
                    detail.setDebitAmount(new BigDecimal("0.00"));
                    detail.setCreditAmount(recAmountD);
                } else {
                    detail.setDebitAmount(payAmountD);
                    detail.setCreditAmount(recAmountD);
                }
                String AcctBal = row.getChildTextTrim("AcctBalance");
                BigDecimal balance = new BigDecimal(AcctBal);
                detail.setBalance(balance);
                String summary = "";
                if (row.getChildTextTrim("Note") != null) {
                    summary = row.getChildTextTrim("Note");
                }
                detail.setExplanation(summary);
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                String receiptNo = MatchRule.getInstance().getReceiptNo(arg0.getAcnt().getAccNo(), transferDate, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detail.setJsonMap(jsonStr);
                detail.setBankDetailNo(HostJournalNo);
                detailList.add(detail);
            }
        } else {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\u3002", (String)"DetailImpl_4", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]), body.getChildText("respondInfo"));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        return detailList;
    }

    public boolean isLastPage(String rspStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element Body = root.getChild("RespondBody");
        BankResponse bankResponse = GYB_Parser.parserCommonInfo(root);
        if ("RET2003".equals(bankResponse.getResponseCode())) {
            return true;
        }
        List rowList = Body.getChildren("RespondRecord");
        return rowList == null || rowList.size() < this.pageSize;
    }
}

