/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gyb.dc.payment;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gyb.dc.payment.aggregate.AggregatePayImpl;
import kd.ebg.aqap.banks.gyb.dc.payment.otherbank.TransferOtherBankImpl;
import kd.ebg.aqap.banks.gyb.dc.payment.samebank.TransferSameBankImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public String getDeveloper() {
        return "simon_wx";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]);
    }

    private void set2SinglePay(PaymentInfo paymentInfo) {
        if (this.isB2eAggregatePayment()) {
            this.setImplClassName(paymentInfo, AggregatePayImpl.class.getName());
        } else if (this.isB2eTransferInBank4UTF8()) {
            if (paymentInfo.is2SameBank()) {
                this.setImplClassName(paymentInfo, TransferSameBankImpl.class.getName());
            } else if (!paymentInfo.is2SameBank()) {
                BigDecimal level;
                BigDecimal amount = paymentInfo.getAmount();
                if (amount.compareTo(level = new BigDecimal("50000")) > 0) {
                    this.addRoute(false, "Amount\uff1a" + amount.toPlainString(), ">", "50000");
                    this.setImplClassName(paymentInfo, TransferOtherBankImpl.class.getName());
                } else {
                    this.addRoute(false, "Amount\uff1a" + amount.toPlainString(), "<=", "50000");
                    this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.gyb.dc.payment.otherbank.superBank.TransferOtherBankImpl.class.getName());
                }
            }
        }
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if (!(this.isPay(paymentInfo) || this.isPay_for_salary(paymentInfo) || this.isPay_for_capital_allocation(paymentInfo))) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"PretreatmentImpl_1", (String)"ebg-aqap-banks-gyb-dc", (Object[])new Object[0]));
        }
        this.set2SinglePay(paymentInfo);
        return busiImplInfo;
    }

    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public boolean isB2eAggregatePayment() {
        return this.assertBusinessConfig("pay_route_sel", "B2eAggregatePayment");
    }

    public boolean isB2eTransferInBank4UTF8() {
        return this.assertBusinessConfig("pay_route_sel", "B2eTransferInBank4UTF8/B2eTransferOutBank4UTF8");
    }
}

