/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bea.dc.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bea.dc.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.bea.dc.utils.BeaPacker;
import kd.ebg.aqap.banks.bea.dc.utils.BeaParser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "3101";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8f6c\u8d26(3101)", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) || "pay".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        return BeaPacker.packPay(request);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        return BeaParser.parsePay(request, responseStr);
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/bcdlserver/bcdlserverServlet");
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
    }
}

