/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bea.dc.utils;

import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bea.dc.BankBusinessConfig;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BeaPacker {
    public static String packHisBalance(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        long until = request.getStartDate().until(request.getEndDate(), ChronoUnit.DAYS);
        if (until > 7L) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1c\u4e9a\u94f6\u884c\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u5927\u4e8e7\u5929", (String)"BeaPacker_0", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]));
        }
        Element root = BeaPacker.createRoot();
        JDomUtils.addChild((Element)root, (String)"SERVICE_CODE", (String)"2203");
        JDomUtils.addChild((Element)root, (String)"TRAN_REF_NO", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)root, (String)"ACCT_NO", (String)accNo);
        JDomUtils.addChild((Element)root, (String)"CCY", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)root, (String)"START_DATE", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"END_DATE", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static Element createRoot() {
        return JDomUtils.createRoot((String)"bcdl");
    }

    public static String packDetail(BankDetailRequest request, String pageTag) {
        BankAcnt acnt = request.getAcnt();
        long until = request.getStartDate().until(request.getEndDate(), ChronoUnit.DAYS);
        if (until > 7L) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1c\u4e9a\u94f6\u884c\u660e\u7ec6\u67e5\u8be2\u65f6\u95f4\u8de8\u5ea6\u4e0d\u80fd\u5927\u4e8e7\u5929\u3002", (String)"BeaPacker_1", (String)"ebg-aqap-banks-bea-dc", (Object[])new Object[0]));
        }
        Element root = BeaPacker.createRoot();
        JDomUtils.addChild((Element)root, (String)"SERVICE_CODE", (String)"2301");
        JDomUtils.addChild((Element)root, (String)"TRAN_REF_NO", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)root, (String)"TOTAL_NUM", (String)"50");
        JDomUtils.addChild((Element)root, (String)"CURRENT_NUM", (String)pageTag);
        JDomUtils.addChild((Element)root, (String)"ACCT_NO", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)root, (String)"CCY", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)root, (String)"START_DATE", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)root, (String)"END_DATE", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packPay(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = BeaPacker.createRoot();
        JDomUtils.addChild((Element)root, (String)"SERVICE_CODE", (String)"3101");
        JDomUtils.addChild((Element)root, (String)"TRAN_REF_NO", (String)paymentInfo.getBankBatchSeqId());
        boolean sameBank = paymentInfo.is2SameBank();
        JDomUtils.addChild((Element)root, (String)"TRAN_FLAG", (String)(sameBank ? "00" : "01"));
        JDomUtils.addChild((Element)root, (String)"ACCT_DEBIT_NO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)root, (String)"ACCT_DEBIT_NAME", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)root, (String)"ACCT_CREDIT_NO", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)root, (String)"ACCT_CREDIT_NAME", (String)paymentInfo.getIncomeAccName());
        if (!sameBank) {
            JDomUtils.addChild((Element)root, (String)"BANK_CODE", (String)paymentInfo.getIncomeCnaps());
        }
        JDomUtils.addChild((Element)root, (String)"CCY", (String)paymentInfo.getCurrency());
        BigDecimal amount = paymentInfo.getAmount().multiply(new BigDecimal(100));
        JDomUtils.addChild((Element)root, (String)"TRAN_AMT", (String)amount.setScale(0).toString());
        boolean individual = paymentInfo.is2Individual();
        String TRAN_REMARK = "";
        if (!StringUtils.isEmpty((String)paymentInfo.getExplanation())) {
            if (!individual && BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
                TRAN_REMARK = paymentInfo.getBankDetailSeqId() + "KD" + paymentInfo.getExplanation();
            } else {
                TRAN_REMARK = paymentInfo.getExplanation();
            }
        }
        JDomUtils.addChild((Element)root, (String)"TRAN_REMARK", (String)TRAN_REMARK);
        JDomUtils.addChild((Element)root, (String)"ACCT_CREDIT_TYPE", (String)(individual ? "1" : "0"));
        JDomUtils.addChild((Element)root, (String)"PRIORITY", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packQueryPay(BankPayRequest request) {
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        Element root = BeaPacker.createRoot();
        JDomUtils.addChild((Element)root, (String)"SERVICE_CODE", (String)"3301");
        JDomUtils.addChild((Element)root, (String)"TRAN_REF_NO", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)root, (String)"TRAN_REF_NO_1", (String)paymentInfo.getBankBatchSeqId());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public static String packBalance(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = BeaPacker.createRoot();
        JDomUtils.addChild((Element)root, (String)"SERVICE_CODE", (String)"2204");
        JDomUtils.addChild((Element)root, (String)"TRAN_REF_NO", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)root, (String)"ACCT_NO", (String)accNo);
        JDomUtils.addChild((Element)root, (String)"CCY", (String)request.getBankCurrency());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }
}

