/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.cmp.services.handler;

import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbc.cmp.services.utils.HsbcUtil;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.proxy.oversea.AbstractMT942Handler;
import kd.ebg.aqap.proxy.oversea.entity.OverseaBalance;
import kd.ebg.aqap.proxy.oversea.entity.OverseaDetail;
import kd.ebg.aqap.proxy.oversea.repository.OverseaBalanceRepository;
import kd.ebg.aqap.proxy.swift.model.SwiftTextBlock;
import kd.ebg.aqap.proxy.swift.model.Tag;
import kd.ebg.aqap.proxy.swift.model.field.Field25;
import kd.ebg.aqap.proxy.swift.model.field.Field34F;
import kd.ebg.aqap.proxy.swift.model.field.Field61;
import kd.ebg.aqap.proxy.swift.model.field.Field86;
import kd.ebg.aqap.proxy.swift.utils.SwiftTagsUtils;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class HSBC_CMP_MT942_Handler
extends AbstractMT942Handler {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(HSBC_CMP_MT942_Handler.class);

    public boolean isNeedToProcessFile(String fileName) {
        return fileName.contains("NHK") || fileName.contains("NCN") || fileName.contains("MT942");
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    protected void processFile(File file, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) {
        String name = file.getName();
        if (!this.isNeedToProcessFile(name)) {
            return;
        }
        try {
            List list = super.readFileContentAsString(file);
            for (SwiftTextBlock aList : list) {
                this.parseCurrDetails(aList, name, detailInfoList, payInfoList, balanceInfoList);
            }
        }
        catch (Exception e) {
            this.logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u5f53\u65e5\u4ea4\u6613\u660e\u7ec6\u62a5\u544a[%1$s]\u51fa\u9519:%2$s\u3002", (String)"HSBC_CMP_MT942_Handler_1", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), new Object[]{name, e});
        }
    }

    private void parseCurrDetails(SwiftTextBlock swiftTextBlock, String fileName, List<OverseaDetail> detailInfoList, List<PaymentInfo> payInfoList, List<OverseaBalance> balanceInfoList) throws SQLException {
        Tag tag86;
        Field25 field25 = new Field25(swiftTextBlock.getTagValue("25"));
        Field34F field34F = new Field34F(swiftTextBlock.getTagValue("34F"));
        this.logger.info("Field25:" + field25.toString());
        String acntNumber = field25.getComponent1();
        String currency = field34F.getComponent1();
        this.parse61To86Tags(swiftTextBlock, acntNumber, currency, fileName, detailInfoList, payInfoList);
        OverseaBalance balanceInfo = new OverseaBalance();
        List tags = swiftTextBlock.getTags();
        int[] tag90CIndex = SwiftTagsUtils.getTagsIndex((List)tags, (String)"90C");
        if (tag90CIndex.length > 0 && (tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)tag90CIndex[0], (int)(tag90CIndex[0] + 1))) != null) {
            this.parseBal86Tags(tag86, balanceInfo, acntNumber, currency, detailInfoList);
        }
        balanceInfo.setUpdateSource(fileName);
        balanceInfo.setNumber(acntNumber);
        balanceInfo.setCurrency(currency);
        balanceInfo.setBankVersion(this.context.getBankVersionID());
        if (detailInfoList.size() > 0) {
            balanceInfo.setBalanceDate(detailInfoList.get(0).getTxDate().atStartOfDay());
        } else {
            balanceInfo.setBalanceDate(LocalDateTime.now());
        }
        balanceInfoList.add(balanceInfo);
    }

    private void parse61To86Tags(SwiftTextBlock swiftTextBlock, String acntNumber, String currency, String fileName, List<OverseaDetail> detailList, List<PaymentInfo> payInfoList) {
        List tags = swiftTextBlock.getTags();
        int[] tag61Index = SwiftTagsUtils.getTagsIndex((List)tags, (String)"61");
        if (0 == tag61Index.length) {
            return;
        }
        for (int aTag61Index : tag61Index) {
            String time;
            Field61 field61 = new Field61(((Tag)tags.get(aTag61Index)).getTagValue());
            OverseaDetail detail = new OverseaDetail();
            String today = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            if (!today.equals(time = today.substring(0, 4) + field61.getComponent2())) {
                this.logger.info(ResManager.loadKDString((String)"\u8be5\u7b14\u660e\u7ec6\u4ea4\u6613\u65e5\u671f\u4e0d\u662f\u4eca\u5929\uff0c\u4e0d\u8fdb\u884c\u89e3\u6790\u3002", (String)"HSBC_CMP_MT942_Handler_2", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]));
                continue;
            }
            detail.setTxDate(LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setNumber(acntNumber);
            detail.setBenefitAccNo("");
            detail.setPayBankName("HSBC");
            detail.setPayBankVersion("HSBC_CMP");
            detail.setDetailFileName(fileName);
            detail.setCreatetime(LocalDateTime.now());
            detail.setCustomId(EBContext.getContext().getCustomID());
            detail.setCurrency(currency);
            BigDecimal amount = field61.getComponent5AsBigDecimal();
            String creditOrDebit = field61.getComponent3();
            if ("C".equalsIgnoreCase(creditOrDebit) || "EC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else if ("D".equalsIgnoreCase(creditOrDebit) || "ED".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("DEBIT");
                detail.setTxAmt(amount);
            } else if ("RC".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount.multiply(new BigDecimal("-1")));
            } else if ("RD".equalsIgnoreCase(creditOrDebit)) {
                detail.setCordFlag("CREDIT");
                detail.setTxAmt(amount);
            } else {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u672a\u80fd\u786e\u5b9a\u501f\u8d37\u6807\u5fd7[%1$s]\u6240\u5c5e\u7684\u7c7b\u578b,\u65e0\u6cd5\u8bbe\u7f6e\u91d1\u989d\u501f\u8d37\u65b9\u5411", (String)"HSBC_CMP_MT940_Handler_3", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), (Object)creditOrDebit);
            }
            String custRef = field61.getComponent7() == null ? "" : field61.getComponent7().trim().toLowerCase();
            detail.setExtField1(custRef);
            String bankRef = field61.getComponent8AsString();
            this.logger.info("Field61:" + field61.toString());
            String transType = field61.getComponent6();
            detail.setTransType(transType);
            PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
            try {
                PaymentInfo paymentInfo = paymentInfoRepository.findByBankDetailSeqID(custRef);
                if (paymentInfo == null) {
                    List list;
                    if (custRef.length() == 8 && (list = paymentInfoRepository.findByBankBatchSeqID(custRef)).size() > 0) {
                        continue;
                    }
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"HSBC_CMP_MT942_Handler_0", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)"PAY_SUCCESS", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"HSBC_CMP_MT942_Handler_0", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]));
                    payInfoList.add(paymentInfo);
                }
            }
            catch (Exception e) {
                this.logger.info(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u5e93\u4e2d\u7684\u4ed8\u6b3e\u6570\u636e\u5931\u8d25\uff0c\u65e0\u6cd5\u66f4\u65b0\u4ed8\u6b3e\u72b6\u6001%1$s\u3002", (String)"HSBC_CMP_MT940_Handler_4", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), (Object)e);
            }
            Tag tag86 = SwiftTagsUtils.getTagBetween((List)tags, (String)"86", (int)aTag61Index, (int)(aTag61Index + 1));
            if (null != tag86) {
                this.deal86Tags(tag86, detail, fileName, currency, custRef);
            }
            detailList.add(detail);
        }
    }

    private void deal86Tags(Tag tag86, OverseaDetail detail, String fileName, String currency, String custRef) {
        Field86 field86 = new Field86(tag86.getTagValue());
        this.logger.info("Field86:" + field86.toString());
        List field86List = field86.getComponents();
        String line1 = (String)field86List.get(0);
        if (line1 != null && line1.startsWith("/BENM/")) {
            this.parseField86Rjct(field86List, detail);
        } else {
            String line2 = (String)field86List.get(1);
            String line3 = (String)field86List.get(2);
            if (line2 != null && line2.startsWith("/BENM/")) {
                this.parseField86CHKPayment(field86List, detail);
            } else if (line2 != null && line2.startsWith("/ORDP/")) {
                this.parseField86Get(field86List, detail);
            } else if (line3 != null && "PAYMENT CHARGES".equalsIgnoreCase(line3)) {
                this.parseField86PaymentCharge(field86List, detail);
            } else if (line3 != null && line3.startsWith("/BENM/")) {
                this.parseField86Payment(field86List, detail);
            } else {
                this.parseField86Other(field86List, detail, currency);
            }
        }
        if (detail.getCordFlag().equals("CREDIT") && !fileName.contains("CN") && !"CNY".equalsIgnoreCase(currency)) {
            String name = null;
            for (String line : field86List) {
                if (StringUtils.isEmpty((String)line) || !line.contains("/ORDP/") || !(name = line.substring(line.indexOf("/ORDP/") + 6, line.length())).contains("/")) continue;
                name = name.substring(0, name.indexOf("/"));
            }
            if (name == null) {
                if (fileName.contains("SG") || fileName.contains("HK")) {
                    detail.setBenefitAccName(this.cut86((String)field86List.get(0)));
                } else if (fileName.contains("AU")) {
                    if ("NTRF".equals(detail.getTransType()) && custRef.equalsIgnoreCase("NONREF")) {
                        detail.setBenefitAccName(this.cut86((String)field86List.get(1)));
                    } else {
                        detail.setBenefitAccName(((String)field86List.get(0)).replaceAll("\\d+", ""));
                    }
                }
            } else {
                detail.setBenefitAccName(name);
            }
        }
        if ("NONREF".equalsIgnoreCase(detail.getBenefitAccName())) {
            detail.setBenefitAccName("");
        }
    }

    private void parseField86Payment(List<String> field86List, OverseaDetail detail) {
        String curLine;
        int index = 1;
        String AC = curLine = field86List.get(index);
        curLine = field86List.get(++index);
        String BENM = curLine.trim();
        if (!(StringUtils.isEmpty((String)(curLine = field86List.get(++index))) || curLine.startsWith("/REMI/") || "NCHG".equals(detail.getTransType()) && curLine.startsWith("LOCAL"))) {
            BENM = BENM + curLine.trim();
            ++index;
        }
        curLine = field86List.get(index);
        String REMI = "";
        if (!StringUtils.isEmpty((String)curLine)) {
            REMI = curLine.trim();
            ++index;
        }
        if (index < field86List.size() && !StringUtils.isEmpty((String)(curLine = field86List.get(index)))) {
            REMI = REMI + curLine.trim();
        }
        detail.setBenefitAccNo(HsbcUtil.safelySubstring(AC, "/AC/".length()).trim());
        detail.setBenefitAccName(HsbcUtil.safelySubstring(BENM, "/BENM/".length()));
        detail.setExplanation(HsbcUtil.safelySubstring(REMI, "/REMI/".length()));
        detail.setUseDesc(HsbcUtil.safelySubstring(REMI, "/REMI/".length()));
    }

    private void parseField86PaymentCharge(List<String> field86List, OverseaDetail detail) {
        String curLine;
        int index = 0;
        String AC = curLine = field86List.get(++index);
        String REMI = curLine = field86List.get(++index);
        String BENM = curLine = field86List.get(++index);
        if (++index < field86List.size()) {
            curLine = field86List.get(index);
            BENM = BENM + curLine;
        }
        detail.setBenefitAccNo(HsbcUtil.safelySubstring(AC, "/AC/".length()).trim());
        detail.setBenefitAccName(HsbcUtil.safelySubstring(BENM, "/BENM/".length()));
        detail.setExplanation(REMI);
        detail.setUseDesc(REMI);
    }

    private void parseField86Get(List<String> field86List, OverseaDetail detail) {
        int index = 1;
        String curLine = field86List.get(index);
        String ORDP = curLine.trim();
        if (!(StringUtils.isEmpty((String)(curLine = field86List.get(++index))) || curLine.startsWith("/REMI/") || "NCHG".equals(detail.getTransType()) && curLine.startsWith("LOCAL"))) {
            ORDP = ORDP + curLine.trim();
            ++index;
        }
        curLine = field86List.get(index);
        String REMI = "";
        if (!StringUtils.isEmpty((String)curLine)) {
            REMI = curLine.trim();
            ++index;
        }
        if (index < field86List.size() && !StringUtils.isEmpty((String)(curLine = field86List.get(index)))) {
            REMI = REMI + curLine.trim();
        }
        detail.setBenefitAccName(HsbcUtil.safelySubstring(ORDP, "/ORDP/".length()));
        detail.setExplanation(HsbcUtil.safelySubstring(REMI, "/REMI/".length()));
        detail.setUseDesc(HsbcUtil.safelySubstring(REMI, "/REMI/".length()));
    }

    private void parseField86CHKPayment(List<String> field86List, OverseaDetail detail) {
        String curLine;
        int index = 0;
        String REMI = curLine = field86List.get(index).trim();
        String BENM = curLine = field86List.get(++index).trim();
        if (!((curLine = field86List.get(++index).trim()) == null || curLine.startsWith("/REMI/") || "NCHG".equals(detail.getTransType()) && curLine.startsWith("LOCAL"))) {
            BENM = BENM + curLine;
        }
        detail.setBenefitAccName(HsbcUtil.safelySubstring(BENM, "/BENM/".length()));
        detail.setExplanation(REMI);
        detail.setUseDesc(REMI);
    }

    private String cut86(String str) {
        int i;
        int start = 0;
        int end = str.length();
        for (i = 0; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            start = i;
            break;
        }
        for (i = start; i < str.length(); ++i) {
            if (str.charAt(i) < '0' || str.charAt(i) > '9') continue;
            end = i - 1;
            break;
        }
        return str.substring(start, end).trim();
    }

    private void parseField86Rjct(List<String> field86List, OverseaDetail detail) {
        int index = 0;
        String curLine = field86List.get(index);
        String BENM = curLine.trim();
        if (!StringUtils.isEmpty((String)(curLine = field86List.get(++index))) && !curLine.startsWith("/RJCT/")) {
            BENM = BENM + curLine.trim();
            ++index;
        }
        curLine = field86List.get(index);
        String RJCT = curLine.trim();
        if (!StringUtils.isEmpty((String)(curLine = field86List.get(++index)))) {
            RJCT = curLine.startsWith("/REMI/") ? curLine.trim() + "\uff0c" + RJCT : RJCT + curLine.trim();
        }
        if (!StringUtils.isEmpty((String)(curLine = field86List.get(++index))) && curLine.startsWith("/REMI/")) {
            RJCT = curLine.trim() + "\uff0c" + RJCT;
        }
        RJCT = RJCT.replace("/RJCT/", "").replace("/REMI/", "");
        detail.setCordFlag("CREDIT");
        detail.setBenefitAccName(HsbcUtil.safelySubstring(BENM, "/BENM/".length()));
        detail.setExplanation(RJCT);
        detail.setUseDesc(RJCT);
    }

    private void parseField86Other(List<String> field86List, OverseaDetail detail, String currency) {
        StringBuilder exp = new StringBuilder();
        for (String line : field86List) {
            if (StringUtils.isEmpty((String)line)) continue;
            exp.append(line).append("\n");
        }
        detail.setExplanation(exp.toString().trim());
        detail.setUseDesc(exp.toString().trim());
        if (currency.equalsIgnoreCase("CNY")) {
            String line1 = field86List.get(0);
            if (!StringUtils.isEmpty((String)line1)) {
                detail.setBenefitAccName(line1);
            } else {
                detail.setBenefitAccName("");
            }
        }
    }

    private void parseBal86Tags(Tag tag86, OverseaBalance balanceInfo, String accNo, String currency, List<OverseaDetail> detailInfoList) {
        Field86 field86 = new Field86(tag86.getTagValue());
        this.logger.info("Field86:" + field86.toString());
        List field86List = field86.getComponents();
        String line1 = (String)field86List.get(0);
        String line2 = (String)field86List.get(1);
        if (line1 != null && line1.startsWith("/OSDR/") && line2 != null && line2.startsWith("BAL")) {
            int index1 = line2.indexOf("/CLGC");
            int index2 = line2.indexOf("/CAVC");
            int index3 = line2.indexOf("/CLGD");
            int index4 = line2.indexOf("/CAVD");
            if (index1 == -1 && index3 == -1) {
                balanceInfo.setCurrentBalance(new BigDecimal(0));
                balanceInfo.setAvailableBalance(new BigDecimal(0));
                balanceInfo.setLastDayBalance(new BigDecimal(0));
            } else {
                String availableBalance;
                String balance;
                if (index1 != -1) {
                    balance = line2.substring(index1 + "/CLGC".length(), index2).replaceAll(",", ".");
                    availableBalance = line2.substring(index2 + "/CAVC".length()).replaceAll(",", ".");
                } else {
                    balance = "-" + line2.substring(index3 + "/CLGD".length(), index4).replaceAll(",", ".");
                    availableBalance = "-" + line2.substring(index4 + "/CAVD".length()).replaceAll(",", ".");
                }
                BigDecimal bal = new BigDecimal(balance);
                balanceInfo.setCurrentBalance(bal);
                balanceInfo.setAvailableBalance(new BigDecimal(availableBalance));
                OverseaBalanceRepository overseaBalanceRepository = (OverseaBalanceRepository)SpringContextUtil.getBean(OverseaBalanceRepository.class);
                EBContext context = EBContext.getContext();
                OverseaBalance lastestBalance = overseaBalanceRepository.getLastestBalance(accNo, context.getCustomID(), context.getBankVersionID(), currency);
                balanceInfo.setLastDayBalance(lastestBalance == null ? new BigDecimal(0) : lastestBalance.getLastDayBalance());
                if (detailInfoList.size() > 0) {
                    if (detailInfoList.size() > 1) {
                        detailInfoList.get(detailInfoList.size() - 1).setBalance(bal);
                        for (int i = detailInfoList.size() - 1; i > 0; --i) {
                            OverseaDetail info = detailInfoList.get(i);
                            BigDecimal txAmt = info.getTxAmt();
                            bal = "CREDIT".equals(info.getCordFlag()) ? bal.subtract(txAmt) : bal.add(txAmt);
                            detailInfoList.get(i - 1).setBalance(bal);
                        }
                    } else {
                        detailInfoList.get(0).setBalance(bal);
                    }
                }
            }
        }
    }
}

