/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbc.cmp.services.handler;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.proxy.oversea.AbstractACKHandler;
import kd.ebg.aqap.proxy.oversea.utils.JDom11Utils;
import kd.ebg.aqap.proxy.oversea.utils.OverseaDBHelper;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import org.apache.commons.io.FileUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class HSBC_CMP_PAY_ACK_XML_Handler
extends AbstractACKHandler {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(HSBC_CMP_PAY_ACK_XML_Handler.class);

    public boolean isNeedToProcessFile(String fileName) {
        return this.isFileLevelACK(fileName) || this.isTransactionLevelACK(fileName);
    }

    public void initContext(EBContext ebContext) {
        this.context = ebContext;
    }

    protected List<PaymentInfo> processFile(File file) {
        String name = file.getName();
        List<Object> list = Lists.newArrayList();
        try {
            if (this.isFileLevelACK(name)) {
                list = this.processFileLevelACK(file);
            } else if (this.isTransactionLevelACK(name)) {
                list = this.processTransactionLevelACK(file);
            }
        }
        catch (Exception e) {
            logger.error(String.format(ResManager.loadKDString((String)"\u5904\u7406\u4ed8\u6b3e\u5e94\u7b54\u62a5\u544a\u5f02\u5e38", (String)"HSBC_CMP_PAY_ACK_XML_Handler_3", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), new Object[0]), (Throwable)e);
        }
        return list;
    }

    private List<PaymentInfo> processTransactionLevelACK(File file) throws Exception {
        logger.info(String.format("TransactionLevelACK file:\r\n %s", FileUtils.readFileToString((File)file, (String)"UTF-8")));
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List pmtList = cstrpt.getChildren("OrgnlPmtInfAndSts", ns);
        HashMap<String, PayGen> map = new HashMap<String, PayGen>(16);
        for (Element ele : pmtList) {
            Element TxInfAndSts = JDom11Utils.getChildElement((Element)ele, (String)"TxInfAndSts", (Namespace)ns);
            String seqId = TxInfAndSts.getChildText("OrgnlEndToEndId", ns);
            String TxSts = TxInfAndSts.getChildText("TxSts", ns);
            Element StsRsnInf = TxInfAndSts.getChild("StsRsnInf", ns);
            String txMsg = TxSts;
            if (StsRsnInf != null) {
                txMsg = StsRsnInf.getChildText("AddtlInf", ns);
            }
            PayGen payGen = new PayGen();
            payGen.setErrorCode(TxSts);
            payGen.setErrorMsg(txMsg);
            map.put(seqId, payGen);
        }
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        for (PaymentInfo paymentInfo : payInfoList) {
            PayGen payGen = (PayGen)map.get(paymentInfo.getBankDetailSeqID());
            if (payGen == null) continue;
            String status = payGen.getErrorCode();
            String txMsg = payGen.getErrorMsg();
            if ("RJCT".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"HSBC_CMP_PAY_ACK_XML_Handler_0", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)status, (String)txMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_CMP_PAY_ACK_XML_Handler_1", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)status, (String)txMsg);
        }
        return payInfoList;
    }

    private List<PaymentInfo> processFileLevelACK(File file) throws Exception {
        logger.info(String.format("FileLevelACK file content:\r\n %s", FileUtils.readFileToString((File)file, (String)"UTF-8")));
        Element root = this.getRootFromFile(file, "UTF-8");
        Namespace ns = root.getNamespace();
        Element cstrpt = JDom11Utils.getUnNullChildElement((Element)root, (String)"CstmrPmtStsRpt", (Namespace)ns);
        Element orgnlgst = JDom11Utils.getUnNullChildElement((Element)cstrpt, (String)"OrgnlGrpInfAndSts", (Namespace)ns);
        String batchId = JDom11Utils.getUnNuLLChildText((Element)orgnlgst, (String)"OrgnlMsgId", (Namespace)ns);
        List payInfoList = OverseaDBHelper.getPaymentInfoByBatchId((String)batchId);
        String GrpSts = orgnlgst.getChildText("GrpSts", ns);
        Element StsRsnInf = orgnlgst.getChild("StsRsnInf", ns);
        String txMsg = GrpSts;
        if (StsRsnInf != null) {
            txMsg = StsRsnInf.getChildText("AddtlInf", ns);
        }
        if (CollectionUtil.isNotEmpty((Collection)payInfoList)) {
            if (GrpSts.startsWith("AC") && GrpSts.length() == 4) {
                EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"HSBC_CMP_PAY_ACK_XML_Handler_CMP", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
            } else if (GrpSts.startsWith("RJCT")) {
                EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"HSBC_CMP_PAY_ACK_XML_Handler_0", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
            } else {
                EBGBusinessUtils.setPaymentState((List)payInfoList, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u786e\u8ba4", (String)"HSBC_CMP_PAY_ACK_XML_Handler_2", (String)"ebg-aqap-banks-hsbc-cmp", (Object[])new Object[0]), (String)GrpSts, (String)txMsg);
            }
        }
        return payInfoList;
    }

    private boolean isFileLevelACK(String fileName) {
        return fileName.contains("ACK1PSRV3");
    }

    private boolean isTransactionLevelACK(String fileName) {
        return fileName.contains("ACK2PSRV3") || fileName.contains("ACKCPSRV3") || fileName.contains("ACKMT999");
    }

    private static class PayGen {
        private String errorCode;
        private String errorMsg;

        private PayGen() {
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }
    }
}

