/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sde.dc.services.payment.outter;

import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sde.dc.services.payment.QueryPayParser;
import kd.ebg.aqap.banks.sde.dc.utils.SDEPackerUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OutterQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String testDate = RequestContextUtils.getBankParameterValue((String)"signDate4Test");
        Element root = SDEPackerUtils.createRootWithHead(Sequence.genSequence(), "B2ETrsResultQryV1");
        Element Body = JDomUtils.addChild((Element)root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)Body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"VoucherDate", (String)"");
        String VoucherJnlNo = ((PaymentInfo)paymentInfos.get(0)).getDetailBizNo();
        if (!StringUtils.isEmpty((String)testDate)) {
            VoucherJnlNo = testDate + VoucherJnlNo.substring(0, 8);
        } else {
            String submitDate = ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.BASIC_ISO_DATE);
            VoucherJnlNo = submitDate + VoucherJnlNo.substring(VoucherJnlNo.length() - 8);
        }
        JDomUtils.addChild((Element)Map2, (String)"VoucherJnlNo", (String)VoucherJnlNo);
        JDomUtils.addChild((Element)Map2, (String)"AcNo", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        return JDomUtils.root2String((Element)root, (String)"GBK");
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        QueryPayParser.parser(request.getPaymentInfos(), responseStr);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "B2ETrsResultQryV1";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001", (String)"OutterQueryPayImpl_0", (String)"ebg-aqap-banks-sde-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("Content-Type", "application/xml");
        StringBuilder sb = new StringBuilder();
        sb.append("/eweb/").append("B2ETrsResultQryV1").append(".do?");
        sb.append("userPassword=").append(RequestContextUtils.getBankParameterValue((String)"userPassword"));
        sb.append("&SIGDATA=1");
        factory.setUri(sb.toString());
    }
}

