/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.lzccb.dc.service.payment.CompanyQueryPayImpl;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.CommonUtil;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.RequestPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import org.jdom2.Element;

public class CompanyPayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return CompanyQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return this.packBatchPay(bankPayRequest);
    }

    public String packBatchPay(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        Element head = RequestPacker.getHeadPackerData("300006", "1", paymentInfos[0].getBankBatchSeqId());
        Element body = RequestPacker.getPayRequestBody(paymentInfos);
        String requestStr = RequestPacker.getRequest(head, body);
        return requestStr;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String res) {
        this.parsePay(bankPayRequest.getPaymentInfoAsArray(), res);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public void parsePay(PaymentInfo[] paymentInfos, String response) {
        Element element = CommonUtil.getResponseElement(response);
        Element head = element.getChild("head");
        BankResponse headRsp = CommonUtil.parseBankResponse(head);
        String bankStatus = headRsp.getResponseCode();
        if ("0_0000".equals(headRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)bankStatus, (String)headRsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)bankStatus, (String)headRsp.getResponseMessage());
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300006";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6279\u91cf\u5bf9\u5916\u652f\u4ed8", (String)"CompanyPayImpl_2", (String)"ebg-aqap-banks-lzccb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

