/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.lzccb.dc.service.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import kd.ebg.aqap.banks.lzccb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.lzccb.dc.service.proxy.FileUpload;
import kd.ebg.aqap.banks.lzccb.dc.service.utils.CommonUtil;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class RequestPacker {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(RequestPacker.class);

    public static Element getHeadPackerData(String serviceId, String fileFlag, String requestNo) throws EBServiceException {
        Element head = new Element("head");
        Date now = new Date();
        String date = DateTimeUtils.format((Date)now, (String)"yyyyMMdd");
        String time = DateTimeUtils.format((Date)now, (String)"HHmmss");
        JDomUtils.addChild((Element)head, (String)"tr_code", (String)serviceId);
        JDomUtils.addChild((Element)head, (String)"cms_corp_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"user_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"org_code", (String)"");
        JDomUtils.addChild((Element)head, (String)"serial_no", (String)"");
        JDomUtils.addChild((Element)head, (String)"req_no", (String)requestNo);
        JDomUtils.addChild((Element)head, (String)"tr_acdt", (String)date);
        JDomUtils.addChild((Element)head, (String)"tr_time", (String)time);
        JDomUtils.addChild((Element)head, (String)"channel", (String)"5");
        JDomUtils.addChild((Element)head, (String)"sign", (String)"");
        JDomUtils.addChild((Element)head, (String)"file_flag", (String)fileFlag);
        JDomUtils.addChild((Element)head, (String)"reserved", (String)"");
        return head;
    }

    public static Element getBalanceRequestBody(BankBalanceRequest request) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        return body;
    }

    public static Element getDetailRequestBody(BankDetailRequest request) throws EBServiceException {
        Element body = new Element("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String testDate = RequestContextUtils.getParameter().getBankParameter("testEnvTime");
        String startDate = StringUtils.isEmpty((String)testDate) ? LocalDateUtil.formatDate((LocalDate)request.getStartDate()) : testDate;
        String endDate = StringUtils.isEmpty((String)testDate) ? LocalDateUtil.formatDate((LocalDate)request.getEndDate()) : testDate;
        JDomUtils.addChild((Element)body, (String)"start_date", (String)startDate);
        JDomUtils.addChild((Element)body, (String)"end_date", (String)endDate);
        return body;
    }

    public static Element getPayRequestBody(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element body = new Element("body");
        String bankBatchSeqId = paymentInfos[0].getBankBatchSeqId();
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)paymentInfos[0].getBankAddress());
        JDomUtils.addChild((Element)body, (String)"count", (String)String.valueOf(paymentInfos.length));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"delay_flag", (String)"");
        String kdFlag = "";
        String content = "CERT_TYPE|CERT_NO|RCV_ACNO|RCV_CUR_CODE|RCV_ACNAME|RCV_ACCADDR|AMT|AS_FLAG|AS_ACNO|AS_ACNAME|RCV_BANK_NO|RCV_BANK_NAME|BANK_FLAG|AREA_FLAG|URGENCY_FLAG|PURPOSE|POSTSCRIPT|BOOKING_FLAG|BOOKING_DATE|BOOKING_TIME|MOBILES|SAVERECVINFO_FLAG|\r\n";
        StringBuilder contentBuilder = new StringBuilder(content);
        BigDecimal totalAmt = new BigDecimal("0.00");
        String separator = "|";
        for (int i = 0; i < paymentInfos.length; ++i) {
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                kdFlag = "@KD";
                PaymentUtil.setKdFlagID((PaymentInfo)paymentInfos[i], (String)paymentInfos[i].getBankDetailSeqId());
            }
            String sameBank = paymentInfos[i].is2SameBank() ? "0" : "1";
            String sameCity = paymentInfos[0].is2SameCity() ? "0" : "1";
            String urgentFlag = paymentInfos[0].is2Urgent() ? "1" : "0";
            contentBuilder.append(separator).append(paymentInfos[i].getBankDetailSeqId()).append(separator).append(paymentInfos[i].getIncomeAccNo()).append(separator).append(paymentInfos[i].getCurrency()).append(separator).append(paymentInfos[i].getIncomeAccName()).append(separator).append(separator).append(paymentInfos[i].getAmount().toString()).append(separator).append(separator).append(separator).append(separator).append(paymentInfos[i].getIncomeCnaps()).append(separator).append(paymentInfos[i].getIncomeBankName()).append(separator).append(sameBank).append(separator).append(sameCity).append(separator).append(urgentFlag).append(separator).append(paymentInfos[i].getExplanation()).append(separator).append(paymentInfos[i].getBankDetailSeqId()).append(kdFlag).append(separator).append(separator).append(separator).append(separator).append(separator).append(separator).append("\r\n");
            totalAmt = totalAmt.add(paymentInfos[i].getAmount());
        }
        String date = LocalDateUtil.formatLocalDateTime((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss");
        String fileName = bankBatchSeqId + "@" + date;
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        JDomUtils.addChild((Element)body, (String)"amt", (String)String.valueOf(totalAmt));
        FileUpload fileUpload = new FileUpload();
        fileUpload.setFileContent(contentBuilder.toString());
        fileUpload.doBiz(fileName);
        return body;
    }

    public static Element getQueryPayBody(PaymentInfo[] paymentInfos) {
        Element body = new Element("body");
        String time = LocalDateUtil.formatDate((LocalDateTime)paymentInfos[0].getRequestTime());
        String testDate = RequestContextUtils.getParameter().getBankParameter("testEnvTime");
        if (StringUtils.isEmpty((String)testDate)) {
            JDomUtils.addChild((Element)body, (String)"start_date", (String)time);
            JDomUtils.addChild((Element)body, (String)"end_date", (String)time);
        } else {
            JDomUtils.addChild((Element)body, (String)"start_date", (String)testDate);
            JDomUtils.addChild((Element)body, (String)"end_date", (String)testDate);
        }
        return body;
    }

    public static Element getQueryPayBodyDetail() {
        Element body = new Element("body");
        String bankBatchSeqId = RequestContextUtils.getRunningParam((String)"bankBatchSeqId");
        String requestTime = RequestContextUtils.getRunningParam((String)"requestTime");
        String serialNo = RequestContextUtils.getRunningParam((String)"serialNo");
        JDomUtils.addChild((Element)body, (String)"serial_no", (String)serialNo);
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)bankBatchSeqId);
        String testDate = RequestContextUtils.getParameter().getBankParameter("testEnvTime");
        boolean isProduct = StringUtils.isEmpty((String)testDate);
        if (isProduct) {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)requestTime);
        } else {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)testDate);
        }
        return body;
    }

    public static String getRequest(Element head, Element body) throws EBServiceException {
        try {
            Element element = new Element("ap");
            JDomUtils.addChild((Element)element, (Element)head);
            JDomUtils.addChild((Element)element, (Element)body);
            String encoding = RequestContextUtils.getCharset();
            String requestStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)element, (String)encoding);
            return CommonUtil.createCommonMsg(requestStr);
        }
        catch (Exception var) {
            logger.error("\u62fc\u63a5\u8bf7\u6c42\u62a5\u6587\u5f02\u5e38===" + var.getMessage());
            throw new EBServiceException((Throwable)var);
        }
    }
}

