/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.newcrossbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.service.payment.PayTypeHelper;
import kd.ebg.aqap.banks.bosh.dc.service.payment.newcrossbank.QueryPaymentImpl;
import kd.ebg.aqap.banks.bosh.dc.service.sign.SignHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.BOSH_URLEncode;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.SettBankKeyWordsRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "transferCrossBank1_1Op";
    }

    public String getBizDesc() {
        return null;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u6d77\u94f6\u884c\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8\u4e1a\u52a1\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element reqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"VIRACNO", (String)"");
        JDomUtils.addChild((Element)reqParam, (String)"OPAC", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)reqParam, (String)"NAME", (String)paymentInfo.getIncomeAccName());
        if (BankBusinessConfig.isSuper()) {
            SettBankKeyWordsRepository settBankKeyWordsRepository = (SettBankKeyWordsRepository)SpringContextUtil.getBean(SettBankKeyWordsRepository.class);
            String clearBankNo = settBankKeyWordsRepository.matchBankNoByKey(paymentInfo.getIncomeBankName());
            if (StringUtils.isEmpty((String)clearBankNo)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u94f6\u884c%s\u7684\u63a5\u6536\u6e05\u7b97\u884c\u884c\u53f7\uff0c\u8bf7\u5728\u6e05\u7b97\u884c\u7ba1\u7406\u9875\u9762\u7ef4\u62a4\u6e05\u7b97\u884c\u53f7\u3002", (String)"Codes_5", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), paymentInfo.getIncomeBankName()));
            }
            JDomUtils.addChild((Element)reqParam, (String)"PBNO", (String)clearBankNo);
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"PBNO", (String)PayTypeHelper.getPBNO(paymentInfo));
        }
        JDomUtils.addChild((Element)reqParam, (String)"TRAM", (String)paymentInfo.getAmount().setScale(2, 4).toString());
        if (BankBusinessConfig.isDescToUse()) {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)CommonUtil.getSubString(paymentInfo.getExplanation(), 20));
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"USAG", (String)paymentInfo.getUseCn());
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)reqParam, (String)"REMK", (String)Packer.addKd(paymentInfo));
        } else {
            String exp = paymentInfo.getExplanation();
            if (exp.length() > 40) {
                exp = exp.substring(0, 40);
            }
            JDomUtils.addChild((Element)reqParam, (String)"REMK", (String)exp);
        }
        if (BankBusinessConfig.isSuper()) {
            JDomUtils.addChild((Element)reqParam, (String)"PATH", (String)"02");
        } else {
            JDomUtils.addChild((Element)reqParam, (String)"PATH", (String)"");
        }
        JDomUtils.addChild((Element)reqParam, (String)"PREDATE", (String)"");
        String packAll = Packer.packAllInOne(paymentInfo.getBankBatchSeqID(), reqParam);
        packAll = packAll.replaceAll("\r", "").replaceAll("\n", "");
        String signedPayMsg = SignHelper.sign(packAll);
        String reqData = BOSH_URLEncode.encode(signedPayMsg);
        String session = LoginAndOut.login4GetSession();
        return Packer.getCommonBizReqData(session, this.getBizCode(), reqData);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List infos = request.getPaymentInfos();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if ("0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(infos);
        return response;
    }

    public int getBatchSize() {
        return 1;
    }

    public boolean match(PaymentInfo info) {
        if ("pay".equalsIgnoreCase(info.getSubBizType())) {
            if (info.is2SameBank()) {
                return BankBusinessConfig.isCrossUsedBySameBank();
            }
            return !BankBusinessConfig.newOrOld();
        }
        return false;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
    }
}

