/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.salary;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bosh.dc.service.payment.PayTypeHelper;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PayPacker {
    private static final String newLine = "\r\n";
    private static final String separator = "|";

    public static String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        StringBuilder sb = new StringBuilder();
        int totalSize = paymentInfos.size();
        BigDecimal totalAmount = new BigDecimal("0.00");
        String accNo = paymentInfos.get(0).getAccNo();
        String salaryNumber = BankBusinessConfig.getPayForSalaryNo(accNo);
        if (StringUtils.isEmpty((String)salaryNumber)) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u4ee3\u53d1\u63a5\u53e3\u4ee3\u53d1\u5355\u4f4d\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u5728\u94f6\u4f01\u8d26\u6237\u9875\u9762\u914d\u7f6e", (String)"PayPacker_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]));
        }
        for (int i = 0; i < paymentInfos.size(); ++i) {
            PaymentInfo info = paymentInfos.get(i);
            totalAmount = totalAmount.add(info.getAmount());
            int serialNo = i + 1;
            PaymentInfoSysFiled.set((PaymentInfo)info, (String)"bosh_serialNo", (String)String.valueOf(serialNo));
            sb.append(serialNo).append(separator).append(info.getIncomeAccName()).append(separator).append(info.getIncomeAccNo()).append(separator).append(info.getAmount()).append(separator);
            if (BankBusinessConfig.isAddKDFlagToPay()) {
                PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)info);
                sb.append(Packer.addKd(info));
            } else {
                String exp = info.getExplanation();
                if (exp.length() > 40) {
                    exp = exp.substring(0, 40);
                }
                sb.append(exp);
            }
            sb.append(separator).append(PayTypeHelper.getBCCD(info)).append(newLine);
        }
        StringBuilder firstLine = new StringBuilder();
        firstLine.append(totalSize).append(separator).append(totalAmount).append(separator).append(salaryNumber).append(separator);
        String payDate = DateUtil.formatDate((Date)new Date());
        firstLine.append(payDate);
        firstLine.append(separator);
        firstLine.append(newLine);
        sb.insert(0, firstLine);
        return sb.toString();
    }
}

