/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.apply;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.apply.atomic.IApply;
import kd.ebg.aqap.business.apply.bank.BankApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankApplyResponse;
import kd.ebg.aqap.business.apply.utils.ApplyConvert;
import kd.ebg.aqap.common.entity.biz.apply.ApplyRequest;
import kd.ebg.aqap.common.entity.biz.apply.ApplyRequestBody;
import kd.ebg.aqap.common.entity.biz.apply.ApplyResponse;
import kd.ebg.aqap.common.entity.biz.apply.ApplyResponseBody;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.PropertyConfigItem;
import kd.ebg.aqap.common.framework.services.BankAcntOpService;
import kd.ebg.aqap.common.framework.services.RegisterService;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;
import kd.ebg.egf.common.model.tenant.Tenants;
import kd.ebg.egf.common.repository.acnt.BankAcntRepository;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.CheckUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.file.FieldUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class ApplyMethod
implements EBServiceMethod<ApplyRequest, ApplyResponse> {
    private BankAcntRepository bankAcntRepository;
    private BankVersionRepository bankVersionRepository;
    private BankLoginRepository bankLoginRepository;
    private RegisterService registerService;
    private BankAcntOpService bankAcntService;
    private BankLoginConfigService bankLoginConfigService;

    public ApplyResponse mappingCurrency(ApplyResponse response) {
        if (response.getBody() != null) {
            String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(response.getBody().getCurrency());
            response.getBody().setCurrency(currency);
        }
        return response;
    }

    public ApplyResponse executeClientRequest(ApplyRequest request, EBContext context) {
        BankLogin bankLogin;
        ApplyResponse response = new ApplyResponse();
        String bankVersionID = request.getBody().getBankVersionID();
        this.bankAcntService = BankAcntOpService.getInstance();
        String customID = request.getBody().getCustomID();
        String accNo = request.getBody().getAccNo();
        Preconditions.checkArgument((!StringUtils.isEmpty((String)accNo) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyMethod_19", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)CheckUtil.checkNumber((String)accNo), (Object)String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u5305\u542b\u975e\u6cd5\u5b57\u7b26,\u8bf7\u91cd\u65b0\u5f55\u5165\u94f6\u884c\u8d26\u53f7", (String)"ApplyMethod_27", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo));
        Preconditions.checkArgument((!StringUtils.isEmpty((String)request.getBody().getAccName()) ? 1 : 0) != 0, (Object)String.format(ResManager.loadKDString((String)"\u8d26\u53f7[%s]\u7684\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyMethod_28", (String)"ebg-aqap-business", (Object[])new Object[0]), accNo));
        Preconditions.checkArgument((boolean)Objects.nonNull(bankVersionID), (Object)ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkArgument((boolean)this.bankAcntService.getEbCurrencies().contains(request.getBody().getCurrency()), (Object)String.format(ResManager.loadKDString((String)"\u5e01\u79cd[%s]\u4e0d\u5728\u94f6\u4f01\u652f\u6301\u7684\u5e01\u79cd\u5217\u8868\u4e2d\u3002", (String)"ApplyMethod_30", (String)"ebg-aqap-business", (Object[])new Object[0]), request.getBody().getCurrency()));
        Preconditions.checkArgument((!StringUtils.isEmpty((String)customID) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5ba2\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyMethod_6", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkArgument((!StringUtils.isEmpty((String)request.getBody().getFunKey()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5f00\u901a\u7684\u529f\u80fd\u3002", (String)"ApplyMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
        Preconditions.checkArgument((!StringUtils.isEmpty((String)request.getBody().getUscCode()) ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApplyMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
        this.registerService = (RegisterService)SpringContextUtil.getBean(RegisterService.class);
        this.bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);
        this.bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);
        this.bankAcntRepository = (BankAcntRepository)SpringContextUtil.getBean(BankAcntRepository.class);
        Tenants tenant = this.registerService.getByCustomID(customID);
        if (tenant == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u672a\u5728\u94f6\u4f01\u4e91\u6ce8\u518c\u3002", (String)"ApplyMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        String bankVersionName = this.getBankVersionName(bankVersionID);
        Preconditions.checkArgument((boolean)this.bankAcntService.currencySupportedByBankVersionID(request.getBody().getCurrency(), bankVersionID, customID), (Object)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u7248\u672c[%1$s]\u672a\u914d\u7f6e\u8be5\u5e01\u79cd[%2$s]\u7684\u6620\u5c04\u5173\u7cfb\uff0c\u8bf7\u5148\u5230\u94f6\u4f01\u4e91\u7ba1\u7406\u5e73\u53f0\u914d\u7f6e\u3002", (String)"ApplyMethod_32", (String)"ebg-aqap-business", (Object[])new Object[0]), bankVersionID, request.getBody().getCurrency()));
        List bankLogins = this.bankLoginRepository.findByBankVersionIdAndCustomId(bankVersionID, customID);
        if (CollectionUtil.isEmpty((Collection)bankLogins)) {
            bankLogin = this.addBankLogin(bankVersionID, bankVersionName, customID, request.getBody().getEnterpriseCode());
        } else {
            bankLogin = (BankLogin)bankLogins.get(0);
            this.updBankLogin(bankVersionID, bankLogin.getKey().getBankLoginId(), customID, request.getBody().getEnterpriseCode());
        }
        BankAcnt bankAcnt = this.bankAcntRepository.findByAccNoAndCustomID(accNo, request.getHeader().getCustomId());
        if (bankAcnt == null) {
            bankAcnt = this.insertAcnt(request.getBody(), bankLogin.getKey().getBankLoginId(), bankLogin.getBankName());
        } else {
            Preconditions.checkArgument((boolean)bankAcnt.getCustomID().equals(request.getHeader().getCustomId()), (Object)ResManager.loadKDString((String)"\u6b64\u8d26\u53f7\u5df2\u7ecf\u7ed1\u5b9a\u5176\u4ed6\u79df\u6237\u53f7\u3002", (String)"ApplyMethod_13", (String)"ebg-aqap-business", (Object[])new Object[0]));
            this.updateAcnt(bankAcnt, request.getBody());
        }
        ApplyResponseBody responseBody = new ApplyResponseBody();
        responseBody.setAccName(bankAcnt.getAccName());
        responseBody.setAccNo(bankAcnt.getAccNo());
        responseBody.setBankName(bankAcnt.getBankName());
        responseBody.setCurrency(bankAcnt.getCurrency());
        responseBody.setCustomID(customID);
        responseBody.setBankLoginID(bankLogin.getKey().getBankLoginId());
        response.setBody(responseBody);
        if ("CMB_OPA".equals(bankLogin.getBankVersionId()) || "ABC_OPA".equals(bankLogin.getBankVersionId()) || "CMB_ECNY".equals(bankLogin.getBankVersionId())) {
            return response;
        }
        if ("CIB_OPA".equals(bankLogin.getBankVersionId())) {
            this.updateBankLoginConfigValue("cust_no", request.getBody().getEnterpriseCode(), request.getHeader().getCustomId(), bankVersionID, bankLogin.getKey().getBankLoginId());
        } else {
            if ("SPDB_OPA".equals(bankLogin.getBankVersionId())) {
                this.updateBankLoginConfigValue("unfSocCrdtNo", request.getBody().getUscCode(), request.getHeader().getCustomId(), bankVersionID, bankLogin.getKey().getBankLoginId());
                return response;
            }
            if ("BOCOM_OPA".equals(bankLogin.getBankVersionId())) {
                this.updateBankLoginConfigValue("cert_no", request.getBody().getEnterpriseCode(), request.getHeader().getCustomId(), bankVersionID, bankLogin.getKey().getBankLoginId());
            } else if (request.getBody().getRepeatApply().booleanValue() && ("PAB_OPA".equals(bankLogin.getBankVersionId()) || "GDB_OPA".equals(bankLogin.getBankVersionId()) || "CIB_OPA".equals(bankLogin.getBankVersionId()))) {
                try {
                    this.apply(bankVersionID, bankLogin.getKey().getBankLoginId(), request, context, "D");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        EBBankApplyResponse result = this.apply(bankVersionID, bankLogin.getKey().getBankLoginId(), request, context, "A");
        responseBody.setThirdVoucher(result.getThirdVoucher());
        responseBody.setAuthURL(result.getAuthURL());
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EBBankApplyResponse apply(String bankVersionID, String bankLoginID, ApplyRequest request, EBContext context, String applyType) {
        IApply apply = (IApply)BankBundleManager.getInstance().getImpl(bankVersionID, IApply.class, (Object)request);
        context.setBankVersionID(bankVersionID);
        context.setBankLoginID(bankLoginID);
        context.initParameter();
        BankApplyRequest bankApplyRequest = ApplyConvert.convert(request);
        bankApplyRequest.setApplyType(applyType);
        MDC.put((String)"bussiness_type", (String)"bussiness_bank");
        try {
            EBBankApplyResponse eBBankApplyResponse = apply.apply(bankApplyRequest);
            return eBBankApplyResponse;
        }
        finally {
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
        }
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return "apply";
    }

    public String getBankVersionName(String bankVersionID) {
        DynamicObject dynamicObject = this.bankVersionRepository.loadDynamicObjectByBankVersionID(bankVersionID);
        if (dynamicObject == null || StringUtils.isEmpty((String)dynamicObject.getString("name"))) {
            throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u6b64\u94f6\u884c\u7248\u672c\u53f7\u5728\u94f6\u4f01\u4e91\u91cc\u4e0d\u5b58\u5728\u3002", (String)"ApplyMethod_14", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        if ("0".equals(dynamicObject.get("enable"))) {
            dynamicObject.set("enable", (Object)"1");
            SaveServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new DynamicObject[]{dynamicObject});
        }
        return dynamicObject.getString("name");
    }

    public BankLogin addBankLogin(String bankVersionID, String bankVersionName, String customID, String enterpriseCode) {
        this.bankLoginConfigService = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
        List<BankLoginConfig> bankLoginConfigs = this.validAndgetConfigVal(bankVersionID, enterpriseCode);
        this.bankLoginConfigService.save(bankLoginConfigs, bankVersionID, bankVersionName, customID);
        List bankLogins = this.bankLoginRepository.findByBankVersionIdAndCustomId(bankVersionID, customID);
        return (BankLogin)bankLogins.get(0);
    }

    public void updBankLogin(String bankVersionID, String bankLoginID, String customID, String enterpriseCode) {
        this.bankLoginConfigService = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
        List<BankLoginConfig> bankLoginConfigs = this.validAndgetConfigVal(bankVersionID, enterpriseCode);
        this.bankLoginConfigService.update(bankLoginConfigs, bankLoginID, customID);
    }

    List<BankLoginConfig> validAndgetConfigVal(String bankVersionID, String enterpriseCode) {
        List bankLoginConfigs = BankBundleManager.getInstance().getBankLoginConfig(bankVersionID);
        ArrayList<BankLoginConfig> result = new ArrayList<BankLoginConfig>(1);
        bankLoginConfigs.stream().forEach(c -> {
            String defaultValue;
            if ("CMB_OPA".equalsIgnoreCase(bankVersionID) && "lgnnam".equalsIgnoreCase(c.getKey().getBankConfigId()) || "CMB_ECNY".equalsIgnoreCase(bankVersionID) && "lgnnam".equalsIgnoreCase(c.getKey().getBankConfigId())) {
                BankLoginConfig bankLoginConfig = new BankLoginConfig();
                FieldUtils.fieldsCopy((Object)c, (Object)bankLoginConfig);
                bankLoginConfig.setMlSourceNames(c.getMlSourceNames());
                bankLoginConfig.setSourceValues(c.getSourceValues());
                bankLoginConfig.setSourceNames(c.getSourceNames());
                bankLoginConfig.setMlDescs(c.getMlDescs());
                bankLoginConfig.setBankConfigValue(enterpriseCode);
                bankLoginConfig.getKey().setBankVersionId(bankVersionID);
                result.add(bankLoginConfig);
                return;
            }
            if ("CMB_OPA".equalsIgnoreCase(bankVersionID) && ("aes_key".equalsIgnoreCase(c.getKey().getBankConfigId()) || "rsa_key".equalsIgnoreCase(c.getKey().getBankConfigId()))) {
                return;
            }
            if ("CMB_ECNY".equalsIgnoreCase(bankVersionID) && ("aes_key".equalsIgnoreCase(c.getKey().getBankConfigId()) || "rsa_key".equalsIgnoreCase(c.getKey().getBankConfigId()))) {
                return;
            }
            if ("GDB_OPA".equals(bankVersionID) && ("private_key".equals(c.getKey().getBankConfigId()) || "public_key".equals(c.getKey().getBankConfigId()))) {
                return;
            }
            String string = "EnterpriseCode".equalsIgnoreCase(c.getKey().getBankConfigId()) ? enterpriseCode : (defaultValue = StringUtils.isEmpty((String)c.getBankConfigValue()) ? "" : c.getBankConfigValue());
            if (!c.getNullable().booleanValue() && StringUtils.isEmpty((String)defaultValue)) {
                throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u524d\u7f6e\u673a%s", (String)"ApplyMethod_24", (String)"ebg-aqap-business", (Object[])new Object[0]), c.getBankConfigName()) + String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApplyMethod_25", (String)"ebg-aqap-business", (Object[])new Object[0]), c.getKey().getBankConfigId())));
            }
            BankLoginConfig bankLoginConfig = new BankLoginConfig();
            FieldUtils.fieldsCopy((Object)c, (Object)bankLoginConfig);
            bankLoginConfig.setMlSourceNames(c.getMlSourceNames());
            bankLoginConfig.setSourceValues(c.getSourceValues());
            bankLoginConfig.setSourceNames(c.getSourceNames());
            bankLoginConfig.setMlDescs(c.getMlDescs());
            bankLoginConfig.setBankConfigValue(defaultValue);
            bankLoginConfig.getKey().setBankVersionId(bankVersionID);
            result.add(bankLoginConfig);
        });
        return result;
    }

    void updateAcnt(BankAcnt bankAcnt, ApplyRequestBody applyRequestBody) {
        DynamicObject dynamicObject = this.bankAcntRepository.findDataByAccNoAndCustomId(bankAcnt.getAccNo(), bankAcnt.getCustomID());
        dynamicObject.set("name", (Object)applyRequestBody.getAccName());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    BankAcnt insertAcnt(ApplyRequestBody applyRequestBody, String bankLoginId, String bankName) {
        BankAcnt bankAcnt = new BankAcnt();
        FieldUtils.fieldsCopy((Object)applyRequestBody, (Object)bankAcnt);
        bankAcnt.setBankLoginId(bankLoginId);
        bankAcnt.setBankVersionId(applyRequestBody.getBankVersionID());
        bankAcnt.setBankName(bankName);
        bankAcnt.setHasReceipt(Boolean.valueOf(false));
        bankAcnt.setBankShortName(BankBundleManager.getInstance().getBankShortName(applyRequestBody.getBankVersionID()));
        bankAcnt.setBankAddress("");
        this.bankAcntService.save(bankAcnt, false);
        List propertyConfigs = BankBundleManager.getInstance().getBankVersionInfo(applyRequestBody.getBankVersionID()).getPropertyConfig().getAllPropertyConfigItems();
        List configItemInfos = propertyConfigs.stream().filter(configItemInfo -> configItemInfo.isAccNo()).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(configItemInfos)) {
            DynamicObject[] dynamicObjects = new DynamicObject[configItemInfos.size()];
            int i = 0;
            for (PropertyConfigItem c : configItemInfos) {
                String defaultValue;
                String string = defaultValue = CollectionUtil.isEmpty((Collection)c.getDefaultValues()) ? "" : c.getCurrentValue();
                if (c.isMustInput() && StringUtils.isEmpty((String)defaultValue)) {
                    throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u8d26\u53f7%s", (String)"ApplyMethod_26", (String)"ebg-aqap-business", (Object[])new Object[0]), c.getName()) + String.format(ResManager.loadKDString((String)"\u5b57\u6bb5[%s]\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ApplyMethod_25", (String)"ebg-aqap-business", (Object[])new Object[0]), c.getKey())));
                }
                dynamicObjects[i] = this.buildAcntAttrDataEntity(c.getKey(), defaultValue, applyRequestBody.getAccNo());
                ++i;
            }
            this.insertAcntAttr(dynamicObjects);
        }
        return bankAcnt;
    }

    void insertAcntAttr(DynamicObject[] dynamicObjects) {
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }

    DynamicObject buildAcntAttrDataEntity(String key, String val, String objectId) {
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"aqap_object_properties");
        dataEntity.set("attr_key", (Object)key);
        dataEntity.set("attr_value", (Object)val);
        dataEntity.set("object_id", (Object)objectId);
        dataEntity.set("object_name", (Object)"BANK_BUSINESS");
        return dataEntity;
    }

    private void updateBankLoginConfigValue(String key, String value, String customId, String bankVersionId, String bankLoginId) {
        QFilter filter1 = new QFilter("custom_id", "=", (Object)customId);
        QFilter filter2 = new QFilter("bank_version_id", "=", (Object)bankVersionId);
        QFilter filter3 = new QFilter("number", "=", (Object)bankLoginId);
        QFilter filter4 = new QFilter("bank_config_id", "=", (Object)key);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bank_login_config", (String)"id, bank_config_value", (QFilter[])new QFilter[]{filter1, filter2, filter3, filter4});
        if (dynamicObjects.length > 0) {
            for (DynamicObject config : dynamicObjects) {
                config.set("bank_config_value", (Object)value);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
        }
    }
}

