/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.codeless.packer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.codeless.packer.BussinessToMap;
import kd.ebg.aqap.business.credit.openCredit.bank.BankOpenCreditDetailRequest;
import kd.ebg.aqap.business.credit.queryCredit.bank.BankQueryCreditDetailRequest;
import kd.ebg.aqap.business.credit.queryCreditReceived.bank.BankQueryCreditReceivedDetailRequest;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.egf.common.codeless.PackerUtil.PackerCommon;
import kd.ebg.egf.common.model.codeless.CodeLess;

public class PackerUtil {
    public static String packerCreditQuery(BankQueryCreditDetailRequest request, Map<String, String> map, String structId, String dateStr) {
        Map<String, String> sourceDate = BussinessToMap.getMapCreditQuery(request, dateStr);
        sourceDate.put("accno", request.getAcnt().getAccNo());
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommonByApp(dataList, map, (String)structId, (String)"queryCredit", (String)"CREDIT");
    }

    public static String packerCreditReceived(BankQueryCreditReceivedDetailRequest request, Map<String, String> map, String structId, String dateStr) {
        Map<String, String> sourceDate = BussinessToMap.getMapCreditReceived(request, dateStr);
        sourceDate.put("accno", request.getAcnt().getAccNo());
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommonByApp(dataList, map, (String)structId, (String)"queryCreditReceived", (String)"CREDIT");
    }

    public static String packerCreditOpen(BankOpenCreditDetailRequest request, Map<String, String> map, String structId, String dateStr) {
        Map<String, String> sourceDate = BussinessToMap.getMapCreditOpen(request.getDetails(), dateStr);
        sourceDate.put("accno", request.getAcnt().getAccNo());
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommonByApp(dataList, map, (String)structId, (String)"openCredit", (String)"CREDIT");
    }

    public static String packerPay(BankPayRequest request, Map<String, String> map, String dateStr, CodeLess codeLess) {
        Map<String, String> sourceDate = BussinessToMap.getMapPay(request.getPaymentInfos(), dateStr);
        if (map != null) {
            sourceDate.putAll(map);
        }
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>(1);
        dataList.add(sourceDate);
        return PackerCommon.packerCommonByCodeless(dataList, map, (CodeLess)codeLess);
    }

    public static String packerBalance(BankBalanceRequest request, Map<String, String> map, String structId, String dateStr) {
        List<Map<String, String>> sourceDate = BussinessToMap.getMapBalance(request, dateStr);
        return PackerCommon.packerCommonByApp(sourceDate, map, (String)structId, (String)"balance", (String)"QUERY");
    }

    public static String packerDetail(BankDetailRequest request, Map<String, String> map, String structId, String dateStr) {
        List<Map<String, String>> sourceDate = BussinessToMap.getMapDetail(request, dateStr);
        return PackerCommon.packerCommonByApp(sourceDate, map, (String)structId, (String)"detail", (String)"QUERY");
    }
}

