/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.currentandfixed;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.currentandfixed.cache.CacheCafStorage;
import kd.ebg.aqap.business.currentandfixed.util.CAFUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CancelNotificationReqDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CancelNotificationRespDetail;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CurrentAndFixedExRequest;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CurrentAndFixedExResponse;
import kd.ebg.aqap.common.entity.biz.curandfixed.exifaze.cancel.CurrentAndFixedRespBody;
import kd.ebg.aqap.common.entity.biz.status.CurAndFixedState;
import kd.ebg.aqap.common.framework.services.CurAndFixedService;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class CafCancelNotificationMethod
implements EBServiceMethod<CurrentAndFixedExRequest, CurrentAndFixedExResponse> {
    EBGLogger logger = EBGLogger.getInstance().getLogger(CafCancelNotificationMethod.class);

    public CurrentAndFixedExResponse executeClientRequest(CurrentAndFixedExRequest currentAndFixedExRequest, EBContext ebContext) throws MalformedURLException {
        List<CurAndFixedInfo> curAndFixedInfos;
        String batchSeqId;
        block14: {
            block13: {
                String key;
                this.checkStructure(currentAndFixedExRequest);
                MDCUtil.clearBussinessMDC();
                MDCUtil.initMDC();
                MDC.put((String)"bussiness_type", (String)"bussiness_process");
                batchSeqId = currentAndFixedExRequest.getBody().getBatchSeqId();
                FEPAccess access = null;
                EBContext context = EBContext.getContext();
                CurAndFixedService curAndFixedService = CurAndFixedService.getInstance();
                List details = currentAndFixedExRequest.getBody().getDetails();
                CancelNotificationReqDetail detail = (CancelNotificationReqDetail)details.get(0);
                String notifyId = detail.getNotifyId();
                String fixedAccNo = detail.getFixedAccNo();
                curAndFixedInfos = curAndFixedService.selectByNotifyIdAndFixedAccNo(notifyId, fixedAccNo);
                if (curAndFixedInfos.isEmpty()) {
                    curAndFixedInfos = curAndFixedService.selectByBatchSeqIDAndDetailSeqID(batchSeqId, detail.getDetailSeqID()).stream().filter(e -> e.getNotifyId().equalsIgnoreCase(notifyId)).collect(Collectors.toList());
                }
                Preconditions.checkArgument((!curAndFixedInfos.isEmpty() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u5c06\u53d6\u6d88\u7684\u901a\u77e5\u6570\u636e\uff01", (String)"CafCancelNotificationMethod_8", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((curAndFixedInfos.size() == 1 ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u51fa\u9519\uff01", (String)"CafCancelNotificationMethod_9", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() != CurAndFixedState.FAIL.getId() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5f85\u53d6\u6d88\u7684\u901a\u77e5\u4e3a\u5931\u8d25\u72b6\u6001\uff0c\u65e0\u6cd5\u53d6\u6d88\uff01", (String)"CafCancelNotificationMethod_10", (String)"ebg-aqap-business", (Object[])new Object[0]));
                Preconditions.checkArgument((((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() == CurAndFixedState.SUCCESS.getId() || ((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus() >= CurAndFixedState.NTS_CANCEL_FINISHED.getId() ? 1 : 0) != 0, (Object)ResManager.loadKDString((String)"\u5f85\u53d6\u6d88\u7684\u901a\u77e5\u5c1a\u672a\u5b8c\u6210\u540c\u6b65\uff0c\u8bf7\u5148\u5b8c\u6210\u540c\u6b65\uff01", (String)"CafCancelNotificationMethod_11", (String)"ebg-aqap-business", (Object[])new Object[0]));
                if (((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() == CurAndFixedState.NTS_CANCEL_FAILED.getId()) {
                    String extData = "";
                    if (StringUtils.isNotEmpty((String)currentAndFixedExRequest.getExtData())) {
                        extData = currentAndFixedExRequest.getExtData();
                    } else if (StringUtils.isNotEmpty((String)currentAndFixedExRequest.getBody().getExtData())) {
                        extData = currentAndFixedExRequest.getBody().getExtData();
                    }
                    if (StringUtils.isEmpty((String)extData)) {
                        return this.res((CurAndFixedInfo)curAndFixedInfos.get(0), CurAndFixedState.NTS_CANCEL_FAILED, currentAndFixedExRequest, batchSeqId);
                    }
                    this.logger.info("\u9644\u52a0\u4fe1\u606f{}", (Object)extData);
                    JSONObject jsonObject = JSONObject.parseObject((String)extData);
                    if (jsonObject.containsKey((Object)"REQ") && "retry".equalsIgnoreCase(jsonObject.getString("REQ"))) {
                        CAFUtil.setState(curAndFixedInfos, CurAndFixedState.NTS_CANCEL_REQ, "", "", "");
                    } else {
                        return this.res((CurAndFixedInfo)curAndFixedInfos.get(0), CurAndFixedState.NTS_CANCEL_FAILED, currentAndFixedExRequest, batchSeqId);
                    }
                }
                if (CacheCafStorage.checkRepeat(key = currentAndFixedExRequest.getHeader().getCustomId() + "_" + batchSeqId)) break block13;
                try {
                    EBContext.initParameter();
                    access = FEPAccessUtil.access((String)context.getBankVersionID(), (String)context.getBankLoginID());
                    if (((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus().intValue() == CurAndFixedState.SUCCESS.getId()) {
                        CAFUtil.setState(curAndFixedInfos, CurAndFixedState.NTS_CANCEL_REQ, "", "", "");
                    }
                    Set<List<CurAndFixedInfo>> lists = CAFUtil.packageCafQuery(curAndFixedInfos);
                    CAFUtil.asyncQuery(lists, (EBRequest)currentAndFixedExRequest);
                }
                catch (Exception e2) {
                    try {
                        throw EBExceiptionUtil.preCheckException((String)ResManager.loadKDString((String)"\u53d6\u6d88\u901a\u77e5\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e38\u3002", (String)"CafCancelNotificationMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]), (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        FEPAccessUtil.release(access);
                        throw throwable;
                    }
                }
                FEPAccessUtil.release((FEPAccess)access);
                break block14;
            }
            this.logger.error("\u53d6\u6d88\u901a\u77e5\u8bf7\u6c42\u51fa\u73b0\u91cd\u590d\uff0c\u4e1a\u52a1\u6279\u6b21\u53f7\uff1a ", new Object[]{batchSeqId});
        }
        return this.res((CurAndFixedInfo)curAndFixedInfos.get(0), CurAndFixedState.getEnumById((int)((CurAndFixedInfo)curAndFixedInfos.get(0)).getStatus()), currentAndFixedExRequest, batchSeqId);
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return null;
    }

    private void checkStructure(CurrentAndFixedExRequest request) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request), (Object)MultiLang.getRequestEmptyTip());
        if (request != null) {
            Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
            if (request.getBody() != null) {
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
                Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody().getDetails()), (Object)ResManager.loadKDString((String)"\u4fee\u6539\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (String)"CafCancelNotificationMethod_7", (String)"ebg-aqap-business", (Object[])new Object[0]));
            }
        }
    }

    private CurrentAndFixedExResponse res(CurAndFixedInfo info, CurAndFixedState state, CurrentAndFixedExRequest currentAndFixedExRequest, String batchSeqId) {
        CurrentAndFixedExResponse resp = new CurrentAndFixedExResponse();
        ArrayList<CancelNotificationRespDetail> d = new ArrayList<CancelNotificationRespDetail>(1);
        CancelNotificationRespDetail t = new CancelNotificationRespDetail();
        t.setFixedAccNo(info.getFixedAccNo());
        t.setFixedAccName(info.getFixedAccName());
        t.setFixedAcntBank(info.getFixedAcntBank());
        t.setFixedAcntBankNo(info.getFixedAcntBankNo());
        t.setNotifyId(info.getNotifyId());
        if (state.getId() == CurAndFixedState.NTS_CANCEL_REQ.getId() || state.getId() < 20) {
            t.setStatus("2");
        } else {
            t.setStatus(state.getId() % 20 + "");
        }
        t.setStatusMsg(info.getStatusMsg());
        t.setBankStatus(info.getBankStatus());
        t.setBankStatusMsg(info.getBankStatusMsg());
        CurrentAndFixedRespBody body = new CurrentAndFixedRespBody();
        d.add(t);
        body.setDetails(d);
        body.setBatchSeqId(batchSeqId);
        resp.setBody(body);
        resp.setHeader(currentAndFixedExRequest.getHeader());
        return resp;
    }
}

