/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.detail.task;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.bank.SecondDetailRequest;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.repository.SecondDetailInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.framework.task.AbstractTask;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class SecondDetailTask
extends AbstractTask {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SecondDetailTask.class);
    private SecondDetailInfoRepository repository = (SecondDetailInfoRepository)SpringContextUtil.getBean(SecondDetailInfoRepository.class);
    private SecondDetailRequest request;
    private EBContext context;

    public SecondDetailTask(SecondDetailRequest request, EBContext context) {
        this.request = request;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doBiz() {
        EBContext.setContext((EBContext)this.context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)this.context);
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        MDC.put((String)"bankVersionID", (String)this.context.getBankVersionID());
        this.logger.infoIndex("\u5f00\u59cb\u8fdb\u884c\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406,{}", (Object)this.context.getBizSeqID());
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u7b2c\u4e8c\u901a\u9053\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u5f00\u59cb\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        LocalDate startDate = this.request.getStartDate();
        LocalDate endDate = this.request.getEndDate();
        List<BankAcnt> bankAcnts = this.request.getBankAcnts();
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        ArrayList<String> errorAccNos = new ArrayList<String>(16);
        if (CollectionUtil.isNotEmpty(bankAcnts)) {
            for (BankAcnt bankAcnt : bankAcnts) {
                try {
                    List<DetailInfo> details = this.syncHistory(bankAcnt, startDate, endDate, this.request);
                    if (!CollectionUtil.isNotEmpty(details)) continue;
                    detailInfos.addAll(details);
                }
                catch (Exception ex) {
                    errorAccNos.add(bankAcnt.getAccNo());
                    this.logger.info("{}\u67e5\u8be2\u8d26\u53f7{}\u5386\u53f2\u660e\u7ec6\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {}\u7684\u4ea4\u6613\u660e\u7ec6\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f:{}", new Object[]{this.context.getBankLoginID(), bankAcnt.getAccNo(), startDate, endDate, ex.getMessage()});
                }
            }
        }
        if (CollectionUtil.isNotEmpty(detailInfos)) {
            this.logger.info("{}\u7b2c\u4e8c\u901a\u9053\u4ea4\u6613\u660e\u7ec6\u51c6\u5907\u63d2\u5165\uff0c\u603b\u6570\u91cf{}", new Object[]{this.context.getBankLoginID(), detailInfos.size()});
            boolean saveSuccess = true;
            TXHandle h = TX.required();
            try {
                Date date = new Date();
                int createDate = Integer.parseInt(DateUtil.formatDate((Date)date, (String)"yyyyMMdd"));
                if (this.repository.exitsByBankLoginIdAndCreateDateAndTransDateBetween(this.context.getBankLoginID(), Integer.valueOf(createDate), startDate, endDate)) {
                    this.repository.deleteByBankLoginIdAndCreateDateAndAccNoNotIn(this.context.getBankLoginID(), Integer.valueOf(createDate), startDate, endDate, errorAccNos);
                }
                this.repository.saveAll(detailInfos);
            }
            catch (Exception ex) {
                saveSuccess = false;
                h.markRollback();
                this.logger.info("{}\u7b2c\u4e8c\u901a\u9053\u4ea4\u6613\u660e\u7ec6\u63d2\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{this.context.getBankLoginID(), ex.getMessage()});
                this.logger.info(ex.getMessage(), (Object)ex);
            }
            finally {
                if (h != null) {
                    try {
                        h.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            if (saveSuccess) {
                this.logger.info("{}\u7b2c\u4e8c\u901a\u9053\u4ea4\u6613\u660e\u7ec6\u63d2\u5165\u6210\u529f\uff0c\u603b\u6570\u91cf{}", new Object[]{this.context.getBankLoginID(), detailInfos.size()});
            }
        } else {
            this.logger.info("\u524d\u7f6e\u673a{}\u672a\u540c\u6b65\u5230\u4ea4\u6613\u660e\u7ec6", (Object)this.context.getBankLoginID());
        }
        this.logger.info("\u5f02\u6b65\u7ebf\u7a0b\u6c60\u5904\u7406\u7b2c\u4e8c\u901a\u9053\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2\u7ed3\u675f\uff0ccustomID={},bankLoginID={}", new Object[]{this.context.getCustomID(), this.context.getBankLoginID()});
        return null;
    }

    private BankDetailRequest buildRequest(BankAcnt acnt, LocalDate startDate, LocalDate endDate, SecondDetailRequest detailRequest) {
        BankDetailRequest request = new BankDetailRequest();
        BankHeader header = new BankHeader();
        request.setHeader(header);
        header.setAcnt(acnt);
        header.setBizType(detailRequest.getHeader().getBizType());
        header.setSubBizType(detailRequest.getHeader().getSubBizType());
        header.setClientName(detailRequest.getHeader().getClientName());
        header.setClientVersion(detailRequest.getHeader().getClientVersion());
        header.setExtData(detailRequest.getHeader().getExtData());
        header.setBankVersionID(acnt.getBankVersionId());
        header.setBankLoginID(acnt.getBankLoginId());
        header.setBizSeqID(detailRequest.getHeader().getLogBizSeqID());
        header.setCustomerID(detailRequest.getHeader().getCustomerID());
        String bankCurrency = CurrencyUtils.convert2Bank((String)acnt.getCurrency(), (String)this.context.getBankVersionID(), (String)this.context.getCustomID());
        header.setBankCurrency(bankCurrency);
        request.setPageSize(detailRequest.getPageSize());
        request.setPageNum(1);
        request.setBankCurrency(bankCurrency);
        request.setStartDate(startDate);
        request.setEndDate(endDate);
        request.setExtData(detailRequest.getExtData());
        request.setSerialNo(detailRequest.getSerialNo());
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DetailInfo> syncHistory(BankAcnt bankAcnt, LocalDate startDate, LocalDate endDate, SecondDetailRequest secondDetailRequest) {
        EBBankDetailResponse response;
        BankDetailRequest request = this.buildRequest(bankAcnt, startDate, endDate, secondDetailRequest);
        this.logger.info("{}\u67e5\u8be2\u8d26\u53f7{}\u5386\u53f2\u660e\u7ec6\u7684\u8d77\u59cb\u65e5\u671f : {} - \u7ed3\u675f\u65e5\u671f : {} ", new Object[]{this.context.getBankLoginID(), bankAcnt.getAccNo(), startDate.toString(), endDate.toString()});
        EBContext.setContext((EBContext)this.context);
        EBContext.initParameter();
        MDC.put((String)"subBizName", (String)"hisDetail");
        IHisDetail detail = (IHisDetail)BankBundleManager.getInstance().getImpl(bankAcnt.getBankVersionId(), IHisDetail.class, (Object)request);
        FEPAccess access = null;
        try {
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            access = FEPAccessUtil.access((String)this.context.getBankVersionID(), (String)this.context.getBankLoginID());
            response = detail.hisDetail(request);
        }
        catch (Throwable throwable) {
            FEPAccessUtil.release(access);
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            throw throwable;
        }
        FEPAccessUtil.release((FEPAccess)access);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        List<DetailInfo> detailInfos = response.getDetails();
        this.dealResponse(bankAcnt, detailInfos);
        return detailInfos;
    }

    private void dealResponse(BankAcnt bankAcnt, List<DetailInfo> detailInfos) {
        HashMap<String, String> currencyMap = new HashMap<String, String>(16);
        this.logger.info("{}\u8d26\u53f7{}\u540c\u6b65\u5230 : {} \u6761\u4ea4\u6613\u660e\u7ec6 ", new Object[]{this.context.getBankLoginID(), bankAcnt.getAccNo(), detailInfos.size()});
        String accType = BankAcntPropertyConfig.getAccType((String)bankAcnt.getAccNo());
        LocalDateTime localDateTime = LocalDateTime.now();
        for (DetailInfo detail : detailInfos) {
            String currency;
            detail.setInsertTime(localDateTime);
            detail.setUpdateTime(localDateTime);
            detail.setBankLoginID(bankAcnt.getBankLoginId());
            detail.setBankVersionID(bankAcnt.getBankVersionId());
            String bankCurrency = detail.getCurrency();
            if (!currencyMap.containsKey(bankCurrency)) {
                currencyMap.put(bankCurrency, CurrencyUtils.convert2Iso((String)bankCurrency));
            }
            if (!StringUtils.isEmpty((String)(currency = (String)currencyMap.get(bankCurrency)))) {
                detail.setCurrency(currency);
            }
            detail.setCustomID(this.context.getCustomID());
            detail.setAccType(accType);
            if (StringUtils.isEmpty((String)detail.getAccNo())) {
                detail.setAccNo(bankAcnt.getAccNo());
            }
            if (StringUtils.isEmpty((String)detail.getAccName())) {
                detail.setAccName(bankAcnt.getAccName());
            }
            if (StringUtils.isEmpty((String)detail.getBankName())) {
                detail.setBankName(bankAcnt.getBankName());
            }
            detail.setCreditAmount(detail.getCreditAmount().setScale(2, 4));
            detail.setDebitAmount(detail.getDebitAmount().setScale(2, 4));
        }
    }
}

