/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing;

import com.google.common.base.Preconditions;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.business.financing.atomic.IQueryFinancing;
import kd.ebg.aqap.business.financing.bank.BankQueryFinancingDetailRequest;
import kd.ebg.aqap.business.financing.bank.EBBankQueryFinancingDetailResponse;
import kd.ebg.aqap.business.financing.util.FinancingConvert;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.aqap.common.entity.biz.financing.query.QueryFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.query.QueryFinancingRequestBody;
import kd.ebg.aqap.common.entity.biz.financing.query.QueryFinancingResponse;
import kd.ebg.aqap.common.entity.biz.financing.query.QueryFinancingResponseBody;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.frame.BankBundleManager;
import kd.ebg.aqap.common.framework.services.FinancingDetailService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.repository.FinancingSyncRecordRespository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.framework.lock.FEPAccess;
import kd.ebg.egf.common.framework.lock.FEPAccessUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.login.BankLogin;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.repository.bank.login.BankLoginRepository;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class QueryFinancingMethod
implements EBServiceMethod<QueryFinancingRequest, QueryFinancingResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryFinancingMethod.class);
    private FinancingDetailService financingDetailService = (FinancingDetailService)SpringContextUtil.getBean(FinancingDetailService.class);
    private BankLoginRepository bankLoginRepository = (BankLoginRepository)SpringContextUtil.getBean(BankLoginRepository.class);

    public QueryFinancingResponse mappingCurrency(QueryFinancingResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public QueryFinancingResponse executeClientRequest(QueryFinancingRequest request, EBContext ebContext) {
        Preconditions.checkArgument((boolean)Objects.nonNull(request.getHeader()), (Object)MultiLang.getRequestHeaderEmptyTip());
        Preconditions.checkArgument((boolean)Objects.nonNull(request.getBody()), (Object)MultiLang.getRequestBodyEmptyTip());
        QueryFinancingRequestBody body = request.getBody();
        Preconditions.checkArgument((boolean)Objects.nonNull(body.getBankLoginID()), (Object)ResManager.loadKDString((String)"\u524d\u7f6e\u673a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryFinancingMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        BankLogin bankLoginInfo = this.bankLoginRepository.findEnableByBankLoginIdAndCustomId(body.getBankLoginID(), request.getHeader().getCustomId());
        if (bankLoginInfo == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u5f53\u524d\u524d\u7f6e\u673a\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"QueryFinancingMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]));
        }
        body.setBankVersionID(bankLoginInfo.getBankVersionId());
        ebContext.setBankLoginID(request.getBody().getBankLoginID());
        ebContext.setBankVersionID(request.getBody().getBankVersionID());
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)ebContext);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        MDC.put((String)"bankVersionID", (String)request.getBody().getBankVersionID());
        this.logger.infoIndex("\u8fdb\u5165\u7406\u8d22\u65b9\u6cd5,{}", (Object)ebContext.getBizSeqID());
        boolean queryFromBank = body.isQueryFromBank();
        this.logger.info("\u67e5\u8be2\u94f6\u884c{}\u7684\u7406\u8d22\u4fe1\u606f", (Object)bankLoginInfo.getBankVersionId());
        if (StringUtils.isNotEmpty((String)body.getProductCode()) || queryFromBank) {
            this.queryFromBank(request);
        } else if (!this.financingDetailService.exitsFinancingRecord(bankLoginInfo.getBankVersionId(), LocalDate.now())) {
            this.queryFromBank(request);
        }
        Page page = this.financingDetailService.getFinancingProductDetailPage(bankLoginInfo.getBankVersionId(), request.getBody().getBankLoginID(), body.getProductCode(), body.getPageNum(), body.getPageSize());
        QueryFinancingResponseBody result = new QueryFinancingResponseBody();
        result.setDetails(page.getContent());
        result.setLastPage(page.isLast());
        result.setTotalCount((int)page.getTotalElements());
        result.setPageSize(page.getSize());
        result.setPageNum(page.getNumber());
        QueryFinancingResponse response = new QueryFinancingResponse();
        response.setBody(result);
        return response;
    }

    private EBBankQueryFinancingDetailResponse queryFromBank(QueryFinancingRequest request) {
        EBBankQueryFinancingDetailResponse response;
        this.logger.info("\u8054\u67e5\u94f6\u884c\uff0c\u4ea7\u54c1\u7f16\u53f7\u4e3a{}", (Object)request.getBody().getProductCode());
        BankQueryFinancingDetailRequest bankRequest = FinancingConvert.convert(request);
        String bankVersionID = request.getBody().getBankVersionID();
        IQueryFinancing queryFinancing = (IQueryFinancing)BankBundleManager.getInstance().getImpl(bankVersionID, IQueryFinancing.class, (Object)request);
        FEPAccess access = null;
        EBContext.initParameter((String)bankVersionID, (String)request.getBody().getBankLoginID());
        try {
            access = FEPAccessUtil.access((String)bankVersionID, (String)request.getBody().getBankLoginID());
            MDC.put((String)"bussiness_type", (String)"bussiness_bank");
            response = queryFinancing.queryFinancing(bankRequest);
        }
        catch (Exception ex) {
            this.logger.error("\u67e5\u8be2\u7406\u8d22\u5217\u8868\u62a5\u9519\uff1a", (Throwable)ex);
            throw EBExceiptionUtil.serviceException((Throwable)ex);
        }
        finally {
            MDC.put((String)"bussiness_type", (String)"bussiness_process");
            FEPAccessUtil.release((FEPAccess)access);
        }
        this.logger.info("\u8054\u67e5\u5230{}\u6761\u7406\u8d22\u8bb0\u5f55", (Object)response.getDetails().size());
        this.dealResponse(response.getDetails(), StringUtils.isNotEmpty((String)request.getBody().getProductCode()));
        if (StringUtils.isEmpty((String)request.getBody().getProductCode())) {
            FinancingSyncRecordRespository financingSyncRecordRespository = (FinancingSyncRecordRespository)SpringContextUtil.getBean(FinancingSyncRecordRespository.class);
            financingSyncRecordRespository.save(bankRequest.getBankVersionID(), request.getHeader().getCustomId(), LocalDate.now());
        }
        return response;
    }

    public boolean needCheckAccNo() {
        return false;
    }

    public String bizName() {
        return BizName.QUERY_FINANCING.name();
    }

    private void dealResponse(List<FinancingProductDetail> details, boolean isSearchByProductCode) {
        if (!CollectionUtils.isEmpty(details)) {
            HashMap<String, String> currencyMap = new HashMap<String, String>(16);
            for (FinancingProductDetail detail : details) {
                String currency;
                String bankCurrency = detail.getCurrency();
                if (!currencyMap.containsKey(bankCurrency)) {
                    currencyMap.put(bankCurrency, CurrencyUtils.convert2Iso((String)bankCurrency));
                }
                if (!StringUtils.isNotEmpty((String)(currency = (String)currencyMap.get(bankCurrency)))) continue;
                detail.setCurrency(currency);
            }
            FinancingDetailService financingDetailService = (FinancingDetailService)SpringContextUtil.getBean(FinancingDetailService.class);
            financingDetailService.insertOrUpdate(details, isSearchByProductCode);
        }
    }
}

