/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.cache.CacheQueryFinancingStorage;
import kd.ebg.aqap.business.financing.util.FinancingConvert;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.business.lang.MultiLang;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingRequest;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingRequestBody;
import kd.ebg.aqap.common.entity.biz.financing.redeem.QueryRedeemFinancingResponse;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.biz.BizName;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.repository.currency.MappingCurrencyRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import org.slf4j.MDC;

public class QueryRedeemFinancingMethod
implements EBServiceMethod<QueryRedeemFinancingRequest, QueryRedeemFinancingResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRedeemFinancingMethod.class);

    public QueryRedeemFinancingResponse mappingCurrency(QueryRedeemFinancingResponse response) {
        if (response.getBody() != null) {
            List list = response.getBody().getDetails();
            HashMap currencyMap = new HashMap(16);
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                list.stream().forEach(item -> {
                    String currency = MappingCurrencyRepository.getInstance().getBizMappingCurrency(item.getCurrency(), currencyMap);
                    item.setCurrency(currency);
                });
            }
        }
        return response;
    }

    public QueryRedeemFinancingResponse executeClientRequest(QueryRedeemFinancingRequest request, EBContext ebContext) throws MalformedURLException {
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        QueryRedeemFinancingRequestBody body = request.getBody();
        String batchSeqId = body.getBatchSeqId();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqId), (Object)MultiLang.getBatchNotEmptyTip());
        this.logger.info("\u83b7\u53d6\u5230\u6279\u6b21\u6d41\u6c34\u53f7{}", (Object)batchSeqId);
        FinancingService service = FinancingService.getInstance();
        List infos = service.selectByBatchSeqID(batchSeqId);
        if (infos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknow_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6279\u6b21\u53f7%s\u3002", (String)"QueryRedeemFinancingMethod_1", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqId));
        }
        String customId = request.getHeader().getCustomId();
        String key = customId + "_" + batchSeqId;
        EBBankFinancingResponse ebBankFinancingResponse = new EBBankFinancingResponse();
        ebBankFinancingResponse.setInfos(infos);
        EBContext.initParameter();
        if (!CacheQueryFinancingStorage.checkRepeat(key)) {
            try {
                boolean isHasSubmmting = infos.stream().anyMatch(info -> info.getStatus().intValue() == FinancingState.SUBMITTING.getId());
                if (isHasSubmmting) {
                    LocalDateTime submitSuccessTime = ((FinancingInfo)infos.get(0)).getSubmitSuccessTime();
                    Duration duration = Duration.between(submitSuccessTime, LocalDateTime.now());
                    long minutes = duration.toMinutes();
                    if (minutes > 20L) {
                        for (FinancingInfo financingInfo : infos) {
                            financingInfo.setStatus(Integer.valueOf(FinancingState.UNKNOWN.getId()));
                            financingInfo.setStatusName(FinancingState.UNKNOWN.getEnName());
                            financingInfo.setStatusMsg(FinancingState.UNKNOWN.getCnName());
                        }
                        BankFinancingRequest bankFinancingRequest = FinancingConvert.getBankFinancingRequest(infos, (EBRequest)request);
                        FinancingUtil.asyncQuery(infos, bankFinancingRequest);
                    }
                } else if (((FinancingInfo)infos.get(0)).getStatus().intValue() != FinancingState.PACKAGED.getId() && ((FinancingInfo)infos.get(0)).getStatus().intValue() != FinancingState.SUCCESS.getId() && ((FinancingInfo)infos.get(0)).getStatus().intValue() != FinancingState.FAIL.getId()) {
                    BankFinancingRequest bankFinancingRequest = FinancingConvert.getBankFinancingRequest(infos, (EBRequest)request);
                    FinancingUtil.asyncQuery(infos, bankFinancingRequest);
                }
            }
            catch (Exception e) {
                this.logger.info("method\u67e5\u8be2\u7406\u8d22\u76f8\u5173\u4ea4\u6613\u72b6\u6001\u5931\u8d25{}", (Object)e.getMessage());
            }
        } else {
            this.logger.info("\u5f53\u524d\u6279\u6b21\u5df2\u7ecf\u5b58\u5728\u540c\u6b65\u67e5\u8be2\u7684\u8bf7\u6c42\uff0c\u672c\u6b21\u67e5\u8be2\u8bf7\u6c42\u4e0d\u751f\u6548");
        }
        return FinancingConvert.convertToResponse((List<FinancingInfo>)infos, request);
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return BizName.QUERY_REDEEM_FINANCING.name();
    }
}

