/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.financing.schedule;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.payment.pool.EBThreadPools;
import kd.ebg.aqap.business.payment.task.BankQueryFinancingTask;
import kd.ebg.aqap.business.util.ScheduleJobPrepareCheck;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.FinancingService;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.bank.info.BankHeader;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.slf4j.MDC;

public class QueryFinancingScheduleJob
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryFinancingScheduleJob.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        FinancingService service = FinancingService.getInstance();
        LocalDateTime updateTime = LocalDateTime.now().minus(5L, ChronoUnit.MINUTES);
        int limitNum = 200;
        List need2QueryInfos = service.selectByStatusAndOwnIsMe(FinancingState.SUBMITED.getId(), FinancingState.UNKNOWN.getId(), updateTime, limitNum);
        this.logger.info("\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b\u8282\u70b9\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\u6570\uff1a" + need2QueryInfos.size());
        if (!need2QueryInfos.isEmpty()) {
            this.logger.info("\u7406\u8d22\u7ed3\u679c\u67e5\u8be2\u8c03\u5ea6\u8bb0\u5f55\u6570\uff1a" + need2QueryInfos.size());
            this.process(need2QueryInfos, false);
        } else {
            updateTime = LocalDateTime.now().minus(20L, ChronoUnit.MINUTES);
            need2QueryInfos = service.selectByStatusAndOwnIsNotMe(FinancingState.SUBMITED.getId(), FinancingState.UNKNOWN.getId(), updateTime, limitNum);
            this.logger.info("\u67e5\u8be2\u5230\u5176\u4ed6\u5b9e\u4f8b\u8282\u70b9\u7b26\u5408\u6761\u4ef6\u7684\u8bb0\u5f55\u6570\uff1a" + need2QueryInfos.size());
            this.process(need2QueryInfos, true);
        }
    }

    private void process(List<FinancingInfo> infos, boolean isModifyOwnToMe) {
        block6: {
            FinancingService service = FinancingService.getInstance();
            if (infos.isEmpty()) break block6;
            Map<String, List<FinancingInfo>> collect = infos.stream().collect(Collectors.groupingBy(FinancingInfo::getBankBatchSeqId));
            if (isModifyOwnToMe) {
                for (Map.Entry<String, List<FinancingInfo>> next : collect.entrySet()) {
                    String bankBatchSeqId = next.getKey();
                    List<FinancingInfo> infoList = next.getValue();
                    try {
                        this.logger.info("\u5c1d\u8bd5\u4fee\u6539\u5176\u4ed6\u8282\u70b9\u7684\u7406\u8d22\u6240\u6709\u8005\u4e3a\u672c\u8282\u70b9. bankBatchSeqId:{}", (Object)bankBatchSeqId);
                        List save = service.modifyOwnToMe(infoList);
                        if (save.isEmpty()) continue;
                        this.submit(save);
                    }
                    catch (Exception e) {
                        this.logger.info("\u5c1d\u8bd5\u5904\u7406\u5176\u4ed6\u8282\u70b9\u7684\u7406\u8d22\u5931\u8d25, bankBatchSeqId:{}", (Object)bankBatchSeqId);
                    }
                }
            } else {
                for (Map.Entry<String, List<FinancingInfo>> entry : collect.entrySet()) {
                    this.logger.info(String.format("\u7406\u8d22\u63d0\u4ea4\u7ebf\u7a0b\u6c60\uff0c\u6279\u6b21\u53f7\u4e3a%s", entry.getKey()));
                    this.submit(entry.getValue());
                }
            }
        }
    }

    private void submit(List<FinancingInfo> financingInfos) {
        FinancingInfo info = financingInfos.get(0);
        String accNo = info.getAccNo();
        String bankVersion = info.getBankVersionID();
        String customerId = info.getCustomId();
        String batchSeqId = info.getBatchSeqId();
        BankAcnt bankAcnt = new BankAcnt();
        bankAcnt.setAccNo(accNo);
        bankAcnt.setBankLoginId(info.getBankLoginID());
        bankAcnt.setBankVersionId(bankVersion);
        String bizType = "B".equalsIgnoreCase(info.getFinancingType()) ? "queryBuyFinancing" : "queryRedeemFinancing";
        String traceId = RequestContext.get().getTraceId();
        if (StringUtils.isEmpty((String)traceId)) {
            traceId = String.valueOf(System.currentTimeMillis());
        }
        this.logger.info("\u5f53\u524d\u8282\u70b9\u5904\u7406\u7406\u8d22\u67e5\u8be2traceId\u4e3a" + traceId);
        EBContext context = EBContext.builder().createTime(System.currentTimeMillis()).customID(customerId).requestSeqID("").bizName(bizType).subBizName(bizType).bankVersionID(bankVersion).bankLoginID(info.getBankLoginID()).bizSeqID(batchSeqId).logBizSeqID(Sequence.gen18Sequence()).logRequestSeqID(traceId).schedule(true).build();
        context.setBankAcnt(bankAcnt);
        EBContext.setContext((EBContext)context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC((EBContext)context);
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        this.logger.infoIndex("\u67e5\u8be2\u7406\u8d22\u72b6\u6001\u8c03\u5ea6\u2014>{}", (Object)batchSeqId);
        if (!ScheduleJobPrepareCheck.checkAcntEnable(accNo, customerId)) {
            this.logger.info("\u67e5\u8be2\u7406\u8d22\u72b6\u6001\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u8d26\u53f7{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u7406\u8d22\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{info.getBankBatchSeqId(), accNo});
            return;
        }
        if (!ScheduleJobPrepareCheck.checkBankLoginEnable(info.getBankLoginID(), customerId)) {
            this.logger.info("\u67e5\u8be2\u7406\u8d22\u72b6\u6001\u8c03\u5ea6\u2014>\u5f53\u524d\u6279\u6b21{}\u7684\u524d\u7f6e\u673a{}\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u8fc7\u6ee4\u6b64\u6279\u6b21\u7684\u7406\u8d22\u8bb0\u5f55\uff0c\u4e0d\u63d0\u4ea4\u5f02\u6b65\u7ebf\u7a0b\u6c60", new Object[]{info.getBankBatchSeqId(), info.getBankLoginID()});
            return;
        }
        this.logger.info("\u51c6\u5907\u63d0\u4ea4\u540c\u6b65\u7406\u8d22\u72b6\u6001\u8c03\u5ea6\u8bb0\u5f55\u6570\uff1a" + financingInfos.size());
        BankFinancingRequest request = this.prepareBankFinancingRequest(financingInfos, bizType);
        String bankLoginId = request.getHeader().getAcnt().getBankLoginId();
        EBThreadPools.getQueryFinancingThreadPool(customerId, bankLoginId).submit((Callable)((Object)new BankQueryFinancingTask(request, context)));
        this.logger.info("\u63d0\u4ea4\u7406\u8d22\u72b6\u6001\u7ebf\u7a0b\u6c60\u6210\u529f");
    }

    private BankFinancingRequest prepareBankFinancingRequest(List<FinancingInfo> financingInfos, String bizType) {
        BankFinancingRequest bankFinancingRequest = new BankFinancingRequest();
        if (!financingInfos.isEmpty()) {
            FinancingInfo financingInfo = financingInfos.get(0);
            bankFinancingRequest.setInfos(financingInfos);
            bankFinancingRequest.setBatchSeqId(financingInfo.getBatchSeqId());
            bankFinancingRequest.setHeader(this.getHeader(financingInfo, bizType));
        }
        return bankFinancingRequest;
    }

    private BankHeader getHeader(FinancingInfo financingInfo, String bizType) {
        BankHeader header = new BankHeader();
        String accNo = financingInfo.getAccNo();
        BankAcnt acnt = BankAcntService.getInstance().selectByCustomIDAndAccNo(accNo, financingInfo.getCustomId());
        String bankVersion = financingInfo.getBankVersionID();
        String currency = financingInfo.getCurrency();
        header.setBankVersionID(bankVersion);
        header.setBankCurrency(currency);
        header.setSubBizType(bizType);
        header.setBizType(bizType);
        header.setLogRequestSeqID(String.valueOf(System.currentTimeMillis()));
        header.setRequestSeqID(Sequence.genSequence());
        header.setClientName("ebc_bankQueryFinancingTask");
        header.setClientVersion("1.0");
        header.setAcnt(acnt);
        this.logger.info("\u7ec4\u88c5\u67e5\u8be2\u7406\u8d22\u94f6\u884c\u8bf7\u6c42\u5934\u5b8c\u6210");
        return header;
    }
}

