/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.cache.CacheQueryPayStorage;
import kd.ebg.aqap.business.payment.task.BankQueryPayTask;
import kd.ebg.aqap.business.payment.utils.AccessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentConvert;
import kd.ebg.aqap.business.payment.utils.QueryPaymentUtil;
import kd.ebg.aqap.common.entity.biz.querypay.QueryPayRequest;
import kd.ebg.aqap.common.entity.biz.querypay.QueryPayResponse;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.entity.biz.status.UpdateOpState;
import kd.ebg.aqap.common.framework.services.PaymentInfoService;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.entity.base.EBRequest;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.biz.EBServiceMethod;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.log.MDCUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;
import org.slf4j.MDC;

public class QueryPayMethod
implements EBServiceMethod<QueryPayRequest, QueryPayResponse> {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayMethod.class);

    public QueryPayResponse executeClientRequest(QueryPayRequest request, EBContext context) {
        JSONObject jsonObject;
        AccessUtils.checkPaymentAllowed(context);
        MDCUtil.clearBussinessMDC();
        MDCUtil.initMDC();
        MDC.put((String)"bussiness_type", (String)"bussiness_process");
        String batchSeqID = request.getBody().getBatchSeqId();
        Preconditions.checkArgument((boolean)StrUtil.isNotBlank((CharSequence)batchSeqID), (Object)ResManager.loadKDString((String)"\u6279\u6b21\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryPayMethod_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
        List infos = PaymentInfoService.getInstance().selectByBatchSeqID(batchSeqID);
        if (infos.isEmpty()) {
            throw EBExceiptionUtil.preCheckException((String)"unknown_batch", (String)String.format(ResManager.loadKDString((String)"\u67e5\u65e0\u6279\u6b21\u53f7: %s\u3002", (String)"QueryPayMethod_3", (String)"ebg-aqap-business", (Object[])new Object[0]), batchSeqID));
        }
        String customId = request.getHeader().getCustomId();
        String key = customId + batchSeqID;
        boolean isForceSync = false;
        String extData = "";
        if (StringUtils.isNotEmpty((String)request.getExtData())) {
            extData = request.getExtData();
        } else if (StringUtils.isNotEmpty((String)request.getBody().getExtData())) {
            extData = request.getBody().getExtData();
        }
        if (StringUtils.isNotEmpty((String)extData) && (jsonObject = JSONObject.parseObject((String)extData)).containsKey((Object)"isUserHandled")) {
            isForceSync = jsonObject.getBoolean("isUserHandled");
        }
        if (isForceSync) {
            HashMap<String, String> runningParams = new HashMap<String, String>(16);
            runningParams.put("isUserHandled", "true");
            context.setRunningParams(runningParams);
            try {
                List<PaymentInfo> result = this.getQueryPaymentInfo(infos);
                Set<List<PaymentInfo>> paymentInfoSet = QueryPaymentUtil.setOfForceQueryPay(infos);
                for (List<PaymentInfo> infoList : paymentInfoSet) {
                    BankPayRequest bankPayRequest = QueryPaymentUtil.getQueryPayRequest(infoList);
                    MDC.put((String)"logger_detail_no", (String)infoList.get(0).getBankBatchSeqID());
                    EBBankPayResponse bankPayResponse = (EBBankPayResponse)((Object)new BankQueryPayTask(bankPayRequest, context).call());
                    if (bankPayResponse != null) {
                        result.addAll(bankPayResponse.getPaymentInfos());
                        continue;
                    }
                    result.addAll(infoList);
                }
                QueryPayResponse queryPayResponse = PaymentConvert.convertToResponse(result, request);
                queryPayResponse.getBody().setExtData(extData);
                return queryPayResponse;
            }
            catch (Exception e) {
                this.logger.error("\u5f3a\u5236\u540c\u6b65\u4ed8\u6b3e\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        if (!CacheQueryPayStorage.checkRepeat(key)) {
            boolean isHasSubmitting = this.isHasSubmitting(infos);
            boolean isQueryPay = this.isNeedQueryPay(infos);
            if (isHasSubmitting) {
                Duration duration;
                long minutes;
                LocalDateTime submitSuccessTime = ((PaymentInfo)infos.get(0)).getSubmitSuccessTime();
                if (submitSuccessTime != null && (minutes = (duration = Duration.between(submitSuccessTime, LocalDateTime.now())).toMinutes()) > 20L) {
                    for (PaymentInfo info : infos) {
                        if (info.getStatus().intValue() != PaymentState.SUBMITTING.getId()) continue;
                        info.setStatus(Integer.valueOf(PaymentState.UNKNOWN.getId()));
                        info.setStatusName(PaymentState.UNKNOWN.getEnName());
                        info.setStatusMsg(String.format(ResManager.loadKDString((String)"%s\uff0c\u63d0\u4ea4\u4e2d\u72b6\u6001\u6301\u7eed\u5df2\u8d85\u8fc720\u5206\u949f\u3002", (String)"QueryPayMethod_4", (String)"ebg-aqap-business", (Object[])new Object[0]), PaymentState.UNKNOWN.getCnName()));
                        info.setEbgID(((SingleNodeIDGetter)SpringContextUtil.getBean(SingleNodeIDGetter.class)).nodeID());
                    }
                }
                Set<List<PaymentInfo>> paymentInfoSet = QueryPaymentUtil.setOfPay(infos);
                QueryPaymentUtil.async(paymentInfoSet, (EBRequest)request);
            } else if (isQueryPay) {
                Set<List<PaymentInfo>> paymentInfoSet = QueryPaymentUtil.setOfPay(infos);
                QueryPaymentUtil.async(paymentInfoSet, (EBRequest)request);
            } else {
                this.logger.info("\u5f53\u524d\u6279\u6b21\u4e0d\u5b58\u5728\u9700\u8981\u540c\u6b65\u72b6\u6001\u7684\u4ed8\u6b3e");
            }
        } else {
            this.logger.info("\u5f53\u524d\u6279\u6b21\u5df2\u7ecf\u5b58\u5728\u540c\u6b65\u67e5\u8be2\u7684\u8bf7\u6c42\uff0c\u672c\u6b21\u67e5\u8be2\u4ed8\u6b3e\u8bf7\u6c42\u4e0d\u751f\u6548");
        }
        return PaymentConvert.convertToResponse((List<PaymentInfo>)infos, request);
    }

    public List<PaymentInfo> getQueryPaymentInfo(List<PaymentInfo> infos) {
        ArrayList<PaymentInfo> result = new ArrayList<PaymentInfo>(16);
        ListIterator<PaymentInfo> infoIterator = infos.listIterator();
        while (infoIterator.hasNext()) {
            PaymentInfo info = (PaymentInfo)infoIterator.next();
            if (!UpdateOpState.MANUAL.getId().equalsIgnoreCase(info.getUpdateOperation()) && !UpdateOpState.PAY_FAIL.getId().equalsIgnoreCase(info.getUpdateOperation())) continue;
            this.logger.info("\u660e\u7ec6\u53f7[" + info.getDetailSeqID() + "]\u4ed8\u6b3e,\u4e0d\u518d\u8fdb\u884c\u5f3a\u5236\u540c\u6b65\u4ed8\u6b3e\u67e5\u8be2");
            result.add(info);
            infoIterator.remove();
        }
        return result;
    }

    public boolean isHasSubmitting(List<PaymentInfo> infos) {
        if (CollectionUtil.isNotEmpty(infos)) {
            return infos.stream().anyMatch(info -> info.getStatus().intValue() == PaymentState.SUBMITTING.getId());
        }
        return false;
    }

    public boolean isNeedQueryPay(List<PaymentInfo> infos) {
        if (CollectionUtil.isNotEmpty(infos)) {
            return infos.stream().anyMatch(info -> info.getStatus() >= PaymentState.SUBMITED.getId() && info.getStatus() <= PaymentState.UNKNOWN.getId());
        }
        return false;
    }

    public boolean needCheckAccNo() {
        return true;
    }

    public String bizName() {
        return "queryPay";
    }
}

