/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.cache;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.ebg.aqap.common.framework.services.EBGNodeService;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.zookeeper.node.SingleNodeIDGetter;

public class CachePayStorage {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(CachePayStorage.class);
    private static final String ebPrefix = "eb_pay_";
    private static final String CHECKED = "checked";
    private static final String NODE = "node";
    private static final String LOCK_TIME = "lockTime";

    private static String getKey(String key) {
        return ebPrefix + key;
    }

    public static boolean checkRepeat(String key) {
        boolean isRepeat;
        String ebKey = CachePayStorage.getKey(key);
        String value = CosmicCache.get((String)ebKey);
        boolean bl = isRepeat = !StringUtils.isEmpty((String)value) && CHECKED.equalsIgnoreCase(value);
        if (!isRepeat) {
            CosmicCache.putIfAbsentWithExpire((String)ebKey, (String)CHECKED, (int)30, (TimeUnit)TimeUnit.SECONDS);
            logger.info("\u5f53\u524d\u8bf7\u6c42\u83b7\u53d6\u5230\u9632\u91cd\u9501\uff1a" + ebKey);
        } else {
            logger.info("\u9632\u91cd\u9501\u5df2\u88ab\u5360\u7528\uff1a" + ebKey);
        }
        return isRepeat;
    }

    public static boolean checkSubmitLock(String key) {
        String ebKey = CachePayStorage.getKey(key);
        String value = CosmicCache.get((String)ebKey);
        if (StringUtils.isEmpty((String)value)) {
            CachePayStorage.setLock(ebKey);
            logger.info("\u5f53\u524d\u8bf7\u6c42\u83b7\u53d6\u5230\u9632\u91cd\u9501\uff1a" + ebKey);
            return false;
        }
        if (!CHECKED.equalsIgnoreCase(value)) {
            Map map = (Map)JsonUtil.fromJson((String)value, Map.class);
            String node = (String)map.get(NODE);
            LocalDateTime recTime = LocalDateUtil.parseDateTime((String)((String)map.get(LOCK_TIME)));
            if (((EBGNodeService)SpringContextUtil.getBean(EBGNodeService.class)).isRestart(node, recTime)) {
                CachePayStorage.setLock(ebKey);
                logger.info("\u5b9e\u4f8b\u53d1\u751f\u91cd\u542f\uff0c\u91cd\u65b0\u83b7\u53d6\u9632\u91cd\u9501\uff1a" + ebKey);
                return false;
            }
            logger.info("\u9632\u91cd\u9501\u5df2\u88ab\u5360\u7528\uff1a" + ebKey);
        } else {
            boolean isRepeat;
            boolean bl = isRepeat = !StringUtils.isEmpty((String)value) && CHECKED.equalsIgnoreCase(value);
            if (!isRepeat) {
                CosmicCache.putIfAbsentWithExpire((String)ebKey, (String)CHECKED, (int)30, (TimeUnit)TimeUnit.MINUTES);
                logger.info("\u5f53\u524d\u8bf7\u6c42\u83b7\u53d6\u5230\u9632\u91cd\u9501\uff1a" + ebKey);
                return false;
            }
            logger.info("\u9632\u91cd\u9501\u5df2\u88ab\u5360\u7528\uff1a" + ebKey);
        }
        return true;
    }

    private static void setLock(String ebKey) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        String node = SingleNodeIDGetter.getInstance().nodeID();
        String lockTime = LocalDateUtil.formatLocalDateTime((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss");
        map.put(NODE, node);
        map.put(LOCK_TIME, lockTime);
        String jsonStr = JsonUtil.toJson(map);
        CosmicCache.putWithExpire((String)ebKey, (String)jsonStr, (int)30, (TimeUnit)TimeUnit.MINUTES);
    }

    private static Map<String, String> getLockInfo(String ebKey) {
        Map<String, String> map = new HashMap<String, String>(2);
        String value = CosmicCache.get((String)ebKey);
        if (!CHECKED.equalsIgnoreCase(value)) {
            map = (Map)JsonUtil.fromJson((String)value, Map.class);
        }
        return map;
    }

    public static boolean checkSubmitRepeat(String key) {
        String ebKey = CachePayStorage.getKey(key);
        String value = CosmicCache.get((String)ebKey);
        boolean isRepeat = !StringUtils.isEmpty((String)value) && CHECKED.equalsIgnoreCase(value);
        return isRepeat;
    }

    public static boolean release(String key) {
        String ebKey = CachePayStorage.getKey(key);
        try {
            CosmicCache.delete((String)ebKey);
            logger.info("\u5f53\u524d\u8bf7\u6c42\u91ca\u653e\u9632\u91cd\u9501\uff1a" + ebKey);
        }
        catch (Throwable e) {
            logger.error("\u6e05\u7406\u4ed8\u6b3e\u8bf7\u6c42\u7684\u9632\u91cd\u9501\u51fa\u9519\uff1a" + e.getMessage());
            return false;
        }
        return true;
    }
}

