/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.intercept;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.business.payment.intercept.IPayControl;
import kd.ebg.aqap.business.payment.intercept.PayControlFactory;
import kd.ebg.aqap.business.payment.intercept.PayControlItem;
import kd.ebg.aqap.business.payment.intercept.PayControlStrategyEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.PaymentSigner;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PayControlRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

@Component
public class PayControlManager {
    public static String checkPaymentInfos(List<PaymentInfo> paymentInfos) {
        List<PayControlItem> items = PayControlManager.getPayControlItems();
        for (PayControlItem item : items) {
            IPayControl control = PayControlFactory.getInstance().getPayControl(item.getStrategy());
            boolean legalPay = control.legalPay(paymentInfos, item.getValues());
            if (legalPay) continue;
            throw EBExceiptionUtil.preCheckException((String)control.echos());
        }
        return null;
    }

    public static Map<PaymentInfo, String> interceptPaymentsAndReasons(List<PaymentInfo> paymentInfos) {
        List<PayControlItem> items = PayControlManager.getPayControlItems();
        HashMap<PaymentInfo, String> reasons = new HashMap<PaymentInfo, String>(16);
        for (PayControlItem item : items) {
            IPayControl control = PayControlFactory.getInstance().getPayControl(item.getStrategy());
            boolean legalPay = control.legalPay(paymentInfos, item.getValues());
            if (legalPay) continue;
            reasons.putAll(control.reasons());
        }
        PaymentSigner signer = (PaymentSigner)SpringContextUtil.getBean(PaymentSigner.class);
        HashSet<List<PaymentInfo>> groupPaymentSet = PayControlManager.getINQueryGroup(paymentInfos, 100);
        for (List<PaymentInfo> toValidatePaymentInfos : groupPaymentSet) {
            Map paymentHashMap = signer.getPaymentHash(toValidatePaymentInfos);
            toValidatePaymentInfos.forEach(paymentInfo -> {
                if (reasons.containsKey(paymentInfo)) {
                    return;
                }
                boolean validate = signer.validate(paymentInfo, paymentHashMap.getOrDefault(paymentInfo.getDetailSeqID(), ""));
                if (!validate) {
                    EBGBusinessUtils.setPaymentState(paymentInfo, PaymentState.FAIL, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4fe1\u606f\u7684\u7b7e\u540d\u9a8c\u8bc1\u672a\u901a\u8fc7\u3002", (String)"PayControlManager_0", (String)"ebg-aqap-business", (Object[])new Object[0]), "", "");
                    reasons.put((PaymentInfo)paymentInfo, ResManager.loadKDString((String)"\u4ed8\u6b3e\u4fe1\u606f\u7684\u7b7e\u540d\u9a8c\u8bc1\u672a\u901a\u8fc7\u3002", (String)"PayControlManager_0", (String)"ebg-aqap-business", (Object[])new Object[0]));
                }
            });
        }
        return reasons;
    }

    private static HashSet<List<PaymentInfo>> getINQueryGroup(List<PaymentInfo> paymentInfos, int groupSize) {
        HashSet<List<PaymentInfo>> groupPaymentInfoSet = new HashSet<List<PaymentInfo>>(16);
        int totalSize = paymentInfos.size();
        int groupNum = totalSize % groupSize == 0 ? totalSize / groupSize : totalSize / groupSize + 1;
        for (int i = 0; i < groupNum; ++i) {
            int start = i * groupSize;
            int end = (i + 1) * groupSize;
            if (end > totalSize) {
                end = totalSize;
            }
            ArrayList<PaymentInfo> newGroupPaymentInfos = new ArrayList<PaymentInfo>(16);
            for (int j = start; j < end; ++j) {
                newGroupPaymentInfos.add(paymentInfos.get(j));
            }
            groupPaymentInfoSet.add(newGroupPaymentInfos);
        }
        return groupPaymentInfoSet;
    }

    private static List<PayControlItem> getPayControlItems() {
        ArrayList<PayControlItem> payControlItems = new ArrayList<PayControlItem>(1);
        String customerID = EBContext.getContext().getCustomID();
        PayControlRepository repository = (PayControlRepository)SpringContextUtil.getBean(PayControlRepository.class);
        List controls = repository.findAllByCustomerNoAndEnableIsTrue(customerID);
        if (CollectionUtils.isEmpty((Collection)controls)) {
            return payControlItems;
        }
        controls.stream().collect(Collectors.groupingBy(c -> c.getStrategy())).entrySet().forEach(entry -> {
            PayControlItem item = new PayControlItem();
            item.setStrategy(PayControlStrategyEnum.valueOf((String)entry.getKey()));
            ArrayList<String> baseLine = new ArrayList<String>(1);
            ((List)entry.getValue()).forEach(pc -> baseLine.add(pc.getValue()));
            item.setValues(baseLine);
            payControlItems.add(item);
        });
        return payControlItems;
    }
}

