/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.payment.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.ebg.aqap.common.framework.properties.BusinessPropertyConfig;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.task.BizTaskTool;
import kd.ebg.egf.common.log.EBGLogger;

public class EBThreadPools {
    private static AtomicInteger count = new AtomicInteger(0);
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(EBThreadPools.class);
    private static final String EB = "eb";
    private static final Map<String, ThreadPool> payThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> queryPayThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> detailThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> curAndFixeThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> queryCurAndFixeThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> overseaThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> financingThreadPools = new ConcurrentHashMap<String, ThreadPool>(20);
    private static final Map<String, ThreadPool> queryFinancingThreadPools = new ConcurrentHashMap<String, ThreadPool>(20);
    private static final Map<String, ThreadPool> secondDetailThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> balanceReconciliationThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> queryBalanceReconciliationThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> balanceStatementThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> simThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);
    private static final Map<String, ThreadPool> attachmentUploadThreadPools = new ConcurrentHashMap<String, ThreadPool>(50);

    private static String getParentKey(String customId, String bankLoginId, String type) {
        String accountId = RequestContext.get().getAccountId();
        StringBuilder sb = new StringBuilder();
        sb.append(EB);
        sb.append('_');
        sb.append(customId);
        sb.append('_');
        sb.append(accountId);
        sb.append('_');
        sb.append(bankLoginId);
        sb.append('_');
        sb.append(type);
        return sb.toString();
    }

    public static ThreadPool threadMaxTest() {
        int maxThreadNUm = BusinessPropertyConfig.getThreadMaxNum();
        if (maxThreadNUm > 0) {
            String bankVersionID = EBContext.getContext().getBankVersionID();
            String customID = EBContext.getContext().getCustomID();
            String bankLoginId = bankVersionID + "-";
            if ("EBG_SIM".equalsIgnoreCase(bankVersionID)) {
                int mod = maxThreadNUm / 3;
                bankLoginId = bankLoginId + count.addAndGet(1) % mod;
                return EBThreadPools.getSimThreadPool(customID, bankLoginId);
            }
            return null;
        }
        return null;
    }

    public static synchronized ThreadPool getSimThreadPool(String customID, String bankLoginId) {
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "sim");
        if (!simThreadPools.containsKey(key)) {
            try {
                logger.info(String.format("\u521b\u5efa\u6a21\u62df\u94f6\u884c\u7ebf\u7a0b\u6c60\uff1a%s", key));
                ThreadPool pool = ThreadPools.newCachedThreadPool((String)key, (int)0, (int)3, (String)"aqap");
                simThreadPools.put(key, pool);
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage());
            }
        }
        return simThreadPools.get(key);
    }

    public static synchronized ThreadPool getPayThreadPool(String customID, String bankLoginId) {
        ThreadPool testPool = EBThreadPools.threadMaxTest();
        if (testPool != null) {
            return testPool;
        }
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "pay");
        if (!payThreadPools.containsKey(key)) {
            try {
                logger.info(String.format("\u521b\u5efa\u4ed8\u6b3e\u7ebf\u7a0b\u6c60\uff1a%s", key));
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
                payThreadPools.put(key, pool);
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage());
            }
        }
        return payThreadPools.get(key);
    }

    public static synchronized ThreadPool getCreditThreadPool(String customID, String bankLoginId) {
        ThreadPool testPool = EBThreadPools.threadMaxTest();
        if (testPool != null) {
            return testPool;
        }
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "openCredit");
        if (!payThreadPools.containsKey(key)) {
            try {
                logger.info(String.format("\u521b\u5efa\u4ed8\u6b3e\u7ebf\u7a0b\u6c60\uff1a%s", key));
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
                payThreadPools.put(key, pool);
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage());
            }
        }
        return payThreadPools.get(key);
    }

    public static synchronized ThreadPool getQueryCreditThreadPool(String customID, String bankLoginId) {
        ThreadPool testPool = EBThreadPools.threadMaxTest();
        if (testPool != null) {
            return testPool;
        }
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "openCreditQuery");
        if (!payThreadPools.containsKey(key)) {
            try {
                logger.info(String.format("\u521b\u5efa\u4ed8\u6b3e\u7ebf\u7a0b\u6c60\uff1a%s", key));
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
                payThreadPools.put(key, pool);
            }
            catch (RuntimeException e) {
                logger.error(e.getMessage());
            }
        }
        return payThreadPools.get(key);
    }

    public static synchronized ThreadPool getQueryPayThreadPool(String customID, String bankLoginId) {
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "queryPay");
        if (!queryPayThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            queryPayThreadPools.put(key, pool);
        }
        return queryPayThreadPools.get(key);
    }

    public static synchronized ThreadPool getDetailThreadPool(String customID, String bankLoginId) {
        ThreadPool testPool = EBThreadPools.threadMaxTest();
        if (testPool != null) {
            return testPool;
        }
        String key = EBThreadPools.getParentKey(customID, bankLoginId, "detail");
        if (!detailThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            detailThreadPools.put(key, pool);
        }
        return detailThreadPools.get(key);
    }

    public static synchronized ThreadPool getCurAndFixedThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "curAndFixed");
        if (!curAndFixeThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            curAndFixeThreadPools.put(key, pool);
        }
        return curAndFixeThreadPools.get(key);
    }

    public static synchronized ThreadPool getQueryCurAndFixedThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "query_curAndFixed");
        if (!queryCurAndFixeThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            queryCurAndFixeThreadPools.put(key, pool);
        }
        return queryCurAndFixeThreadPools.get(key);
    }

    public static synchronized ThreadPool getOverseaThreadPool(String customID, String bankVersion) {
        String key = EBThreadPools.getParentKey(customID, bankVersion, "oversea");
        if (!overseaThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            overseaThreadPools.put(key, pool);
        }
        return overseaThreadPools.get(key);
    }

    public static synchronized ThreadPool getFinancingThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "financing");
        if (!financingThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            financingThreadPools.put(key, pool);
        }
        return financingThreadPools.get(key);
    }

    public static synchronized ThreadPool getQueryFinancingThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "query_financing");
        if (!queryFinancingThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            queryFinancingThreadPools.put(key, pool);
        }
        return queryFinancingThreadPools.get(key);
    }

    public static synchronized ThreadPool getSecondDetailThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "query_secondDetail");
        if (!secondDetailThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            secondDetailThreadPools.put(key, pool);
        }
        return secondDetailThreadPools.get(key);
    }

    public static synchronized ThreadPool getQueryBalanceReconciliationThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "query_balance_reconciliation");
        if (!queryBalanceReconciliationThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            queryBalanceReconciliationThreadPools.put(key, pool);
        }
        return queryBalanceReconciliationThreadPools.get(key);
    }

    public static synchronized ThreadPool getBalanceReconciliationThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "balance_reconciliation");
        if (!balanceReconciliationThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            balanceReconciliationThreadPools.put(key, pool);
        }
        return balanceReconciliationThreadPools.get(key);
    }

    public static synchronized ThreadPool getBalanceStatementThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "balance_statement");
        if (!balanceStatementThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            balanceStatementThreadPools.put(key, pool);
        }
        return balanceStatementThreadPools.get(key);
    }

    public static synchronized ThreadPool getAttachmentUploadThreadPool(String customID, String bankLoginID) {
        String key = EBThreadPools.getParentKey(customID, bankLoginID, "attachment_upload");
        if (!attachmentUploadThreadPools.containsKey(key)) {
            ThreadPool pool = ThreadPools.newFixedThreadPool((String)key, (int)3, (String)"aqap");
            attachmentUploadThreadPools.put(key, pool);
        }
        return attachmentUploadThreadPools.get(key);
    }

    public static String createBizTask(EBContext context) {
        return BizTaskTool.getInstance().createBizTask(context);
    }

    public static String createScheduleBizTask(EBContext context) {
        return BizTaskTool.getInstance().createBizTask(context);
    }
}

