/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.business.util;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class BalanceUtils {
    public static final CurrentBalanceVerification currentBalanceVerification = new CurrentBalanceVerification();

    public static String inconsistentCurrency() {
        String errorMsg = ResManager.loadKDString((String)"\u5f02\u5e38\u4fe1\u606f:\u94f6\u884c\u8fd4\u56de\u7684\u5e01\u79cd\u4e0e\u8bf7\u6c42\u7684\u5e01\u79cd\u4e0d\u4e00\u81f4\u3002\u5efa\u8bae\u89e3\u51b3\u65b9\u6848\uff1a", (String)"BalanceUtils_0", (String)"ebg-aqap-business", (Object[])new Object[0]);
        return ShowTipUtil.getCurrencyNotEqualTipsWithError(errorMsg);
    }

    public static String inconsistentAcc() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u8d26\u53f7\u4e0e\u8bf7\u6c42\u7684\u8d26\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"BalanceUtils_1", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String wrongDateFormatter() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"BalanceUtils_2", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String nonNullCurrentBalance() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceUtils_3", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static String wrongBalanceFormat() {
        return ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e0d\u662f\u6709\u6548\u7684\u683c\u5f0f\u3002", (String)"BalanceUtils_4", (String)"ebg-aqap-business", (Object[])new Object[0]);
    }

    public static BigDecimal any(String bal) {
        try {
            return new BigDecimal(bal);
        }
        catch (Exception e) {
            return null;
        }
    }

    static class CurrentBalanceVerification
    implements Verification {
        private String message;

        CurrentBalanceVerification() {
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public boolean apply(String value) {
            if (StringUtils.isEmpty((String)value)) {
                this.message = BalanceUtils.nonNullCurrentBalance();
                return false;
            }
            try {
                new BigDecimal(value);
                return true;
            }
            catch (NumberFormatException e) {
                this.message = BalanceUtils.wrongBalanceFormat();
                return false;
            }
        }
    }

    public static interface Verification {
        public String message();

        public boolean apply(String var1);
    }
}

