/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.balance;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    public String pack(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"Account", (String)bankBalanceReconciliationRequest.getDetail().getAccNo());
        String balanceMonth = bankBalanceReconciliationRequest.getDetail().getMonth();
        JDomUtils.addChild((Element)Result, (String)"balanceDate", (String)(balanceMonth + "01"));
        JDomUtils.addChild((Element)Result, (String)"updateCts", (String)"1");
        Element list = new Element("list");
        JDomUtils.addChild((Element)list, (String)"ccy", (String)bankBalanceReconciliationRequest.getDetail().getCurrency());
        String checkStatus = bankBalanceReconciliationRequest.getDetail().getCheckStatus();
        JDomUtils.addChild((Element)list, (String)"reconResult", (String)("Y".equals(checkStatus) ? "0" : "1"));
        JDomUtils.addChild((Element)Result, (Element)list);
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(EBContext.getContext().getBankRequestSeq(), "EDZ002", xmlStr);
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String responseStr) {
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        String result = root.getChildText("stt");
        if ("S".equals(result)) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)result, (String)BalanceReconciliationState.SUCCESS.getCnName());
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.FAIL, (String)result, (String)BalanceReconciliationState.FAIL.getCnName());
        }
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "EDZ002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u53cd\u9988", (String)"BalanceReconciliationImpl_0", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return true;
    }
}

