/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.pab.dc.services.payment.income;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.pab.dc.services.PackerHelper;
import kd.ebg.aqap.banks.pab.dc.services.PageUtil;
import kd.ebg.aqap.banks.pab.dc.services.ParserHelper;
import kd.ebg.aqap.banks.pab.dc.services.payment.company.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return ResManager.loadKDString((String)"4047", (String)"PayImpl_6", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u540c\u884c\u5bf9\u79c1\u4ee3\u6263", (String)"PayImpl_7", (String)"ebg-aqap-banks-pab-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return this.isIncome(info);
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        Element Result = new Element("Result");
        JDomUtils.addChild((Element)Result, (String)"ThirdVoucher", (String)paymentInfos[0].getBankBatchSeqId());
        JDomUtils.addChild((Element)Result, (String)"AGREE_NO", (String)"");
        JDomUtils.addChild((Element)Result, (String)"BusiType", (String)"");
        JDomUtils.addChild((Element)Result, (String)"PayType", (String)"0");
        JDomUtils.addChild((Element)Result, (String)"Currency", (String)paymentInfos[0].getCurrency());
        JDomUtils.addChild((Element)Result, (String)"OthBankFlag", (String)"");
        JDomUtils.addChild((Element)Result, (String)"SrcAccNo", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)Result, (String)"TotalNum", (String)String.valueOf(paymentInfos.length));
        Element totalAmountElement = JDomUtils.addChild((Element)Result, (String)"TotalAmount");
        JDomUtils.addChild((Element)Result, (String)"SettleType", (String)"1");
        BigDecimal totalAmont = new BigDecimal("0.00");
        for (int i = 0; i < paymentInfos.length; ++i) {
            totalAmont = totalAmont.add(paymentInfos[i].getAmount());
            Element HOResultSet4047R = JDomUtils.addChild((Element)Result, (String)"HOResultSet4047R");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"SThirdVoucher", (String)paymentInfos[i].getBankDetailSeqId());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"CstInnerFlowNo", (String)"");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OthAreaFlag", (String)(paymentInfos[i].is2SameCity() ? "N" : "Y"));
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"IdType", (String)"");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"IdNo", (String)"");
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppBankName", (String)paymentInfos[i].getIncomeBankName());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppAccNo", (String)paymentInfos[i].getIncomeAccNo());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppAccName", (String)paymentInfos[i].getIncomeAccName());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"OppBranchId", (String)paymentInfos[i].getIncomeCnaps());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"Province", (String)paymentInfos[i].getIncomeProvince());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"City", (String)paymentInfos[i].getIncomeCity());
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfos[i].getAmount()));
            JDomUtils.addChild((Element)HOResultSet4047R, (String)"PostScript", (String)paymentInfos[i].getExplanation());
        }
        totalAmountElement.setText(BigDecimalHelper.plain2((BigDecimal)totalAmont));
        String xmlStr = JDomUtils.root2StringNoIndentLineNoSeparator((Element)Result, (String)RequestContextUtils.getCharset());
        return PackerHelper.createReqMsgWithHead(Sequence.genSequence(), "4047", xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BankResponse bankRsp = new BankResponse();
        PageUtil pageUtil = ParserHelper.parseResponse(responseStr, bankRsp);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element root = JDomUtils.string2Root((String)pageUtil.getXmlStr(), (String)RequestContextUtils.getCharset());
        EBGBusinessUtils.setPaymentState((PaymentInfo[])paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage());
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

