/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ccqtgb.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.BankCode;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.DC_RequestPacker;
import kd.ebg.aqap.banks.ccqtgb.dc.services.helper.DC_ResponseParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public String pack(BankBalanceRequest rqst) {
        return DC_RequestPacker.getBalanceMessageFYI(rqst.getAcnt());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String rspStr) {
        BankResponse response = DC_ResponseParser.parserCommonHead(rspStr);
        if (!BankCode.SUCCESS_CODE.equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        EBBankBalanceResponse result = new EBBankBalanceResponse();
        List<BalanceInfo> balanceInfos = this.parserBalanceMessage(rqst, rqst.getAcnt(), rspStr);
        result.setBalances(balanceInfos);
        return result;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return BankCode.BANLANCE_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-ccqtgb-dc", (Object[])new Object[0]);
    }

    public List<BalanceInfo> parserBalanceMessage(BankBalanceRequest rqst, BankAcnt acnt, String rspStr) {
        ArrayList<BalanceInfo> infos = new ArrayList<BalanceInfo>(16);
        String encoding = EBContext.getContext().getCharsetName();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        Element bodyEle = root.getChild("Body");
        List resList = bodyEle.getChildren("List");
        List maps = ((Element)resList.get(0)).getChildren("Map");
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            BalanceInfo balanceInfo = new BalanceInfo();
            this.setCurrentBalance(balanceInfo, map.getChildText("Balance"));
            this.setAvailableBalance(balanceInfo, map.getChildText("AvailBal"));
            String currency = map.getChildText("Currency") == null ? rqst.getBankCurrency() : map.getChildText("Currency");
            this.setBankCurrency(balanceInfo, rqst.getBankCurrency(), currency);
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), map.getChildText("AcNo"));
            infos.add(balanceInfo);
        }
        return infos;
    }
}

