/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scnx.dc.services.payment.group;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scnx.dc.SCNXDCMetaDataImpl;
import kd.ebg.aqap.banks.scnx.dc.services.payment.CommonPayParser;
import kd.ebg.aqap.banks.scnx.dc.services.payment.group.QueryPayImpl;
import kd.ebg.aqap.banks.scnx.dc.services.utils.CommonPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"exchangeUri"));
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = CommonPacker.packHeader(this.getBizCode(), paymentInfo.getBankDetailSeqId());
        Element body = JDomUtils.addChild((Element)root, (String)"BODY");
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NO", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PAY_PTY_ACCT_NM", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NO", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"RCV_PTY_ACCT_NM", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"RCV_ACT_OPN_ACCT_BNK_BNK_NO", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"RCV_ACT_OPN_ACCT_BNK_BNK_NM", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)body, (String)"TX_AMT", (String)paymentInfo.getAmount().toPlainString());
        JDomUtils.addChild((Element)body, (String)"CUR_CD", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"TX_USAGE_COMNT", (String)paymentInfo.getExplanation());
        JDomUtils.addChild((Element)body, (String)"REMRK", (String)"");
        JDomUtils.addChild((Element)body, (String)"GRPPRNTCORPCUSTNO", (String)RequestContextUtils.getBankParameterValue((String)SCNXDCMetaDataImpl.custom_no));
        JDomUtils.addChild((Element)body, (String)"BIZFLOW", (String)paymentInfo.getBankDetailSeqID());
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"BANKFLAG", (String)"0");
        } else {
            JDomUtils.addChild((Element)body, (String)"BANKFLAG", (String)"1");
        }
        JDomUtils.addChild((Element)body, (String)"TSFACCTMANRCD", (String)"3");
        if (paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)body, (String)"TRANFLG", (String)"4");
        } else {
            JDomUtils.addChild((Element)body, (String)"TRANFLG", (String)"5");
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        new CommonPayParser().parsePay(bankPayRequest, s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "TC013";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u96c6\u56e2\u5bf9\u5916\u4ed8\u6b3e", (String)"PayImpl_0", (String)"ebg-aqap-banks-scnx-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

