/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.opa.services.apply;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.opa.utils.ApplyStatus;
import kd.ebg.aqap.banks.cmbc.opa.utils.CMBCBankResponse;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcPacker;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcParser;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcRequest;
import kd.ebg.aqap.banks.cmbc.opa.utils.OpenIDUtil;
import kd.ebg.aqap.business.apply.atomic.AbstractQueryApplyImpl;
import kd.ebg.aqap.business.apply.atomic.IQueryApply;
import kd.ebg.aqap.business.apply.bank.BankQueryApplyRequest;
import kd.ebg.aqap.business.apply.bank.EBBankQueryApplyResponse;

public class QueryApplyImpl
extends AbstractQueryApplyImpl
implements IQueryApply {
    public String pack(BankQueryApplyRequest request) {
        CmbcRequest cmbcRequest = new CmbcRequest("account.auth.status");
        HashMap<String, Object> busiParamMap = new HashMap<String, Object>();
        busiParamMap.put("src_req_seq", request.getThirdVoucher());
        cmbcRequest.setBusiParamMap(busiParamMap);
        return CmbcPacker.prepareParams(cmbcRequest);
    }

    public EBBankQueryApplyResponse parse(BankQueryApplyRequest request, String responseStr) {
        Map responseMap = (Map)JSON.parseObject((String)responseStr, Map.class);
        CMBCBankResponse bankResponse = CmbcParser.getBankResponse(responseMap);
        if ("false".equals(bankResponse.getResponseCode())) {
            EBBankQueryApplyResponse result = new EBBankQueryApplyResponse();
            result.setStatus(ApplyStatus.FAIL.getReturnType());
            result.setDesc(bankResponse.getResponseMessage());
            result.setThirdVoucher("");
            return result;
        }
        JSONObject busiJson = JSON.parseObject((String)bankResponse.getResponseBusi());
        String openId = busiJson.getString("open_id");
        String status = busiJson.getString("status");
        if (String.valueOf(ApplyStatus.SUCCESS.getStatus()).equals(status)) {
            OpenIDUtil.updateOpenID(request.getHeader().getCustomerID(), openId, request.getAccountNo());
        }
        EBBankQueryApplyResponse result = new EBBankQueryApplyResponse();
        ApplyStatus applyStatus = ApplyStatus.getEnumDesc(status);
        result.setStatus(applyStatus.getReturnType());
        result.setDesc(applyStatus.getDesc());
        result.setThirdVoucher(request.getThirdVoucher());
        return result;
    }

    public String getDeveloper() {
        return "kylin";
    }

    public String getBizCode() {
        return "status";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6388\u6743\u72b6\u6001\u67e5\u8be2", (String)"QueryApplyImpl_0", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]);
    }
}

