/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.services.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.authorized.AuthorizedPayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.company.innerBank.InnerBankPayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.company.outterBank.OutterBankPayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.otherbank.PayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.salary.SalaryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.services.payment.singlepay.XHJ8016Impl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public String getDeveloper() {
        return "0xC";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        String subBizType = paymentInfo.getSubBizType();
        if (this.isPay_for_capital_allocation(paymentInfo)) {
            if (this.isTransferToCompany()) {
                this.setSubBizType4Pay(paymentInfo);
            } else {
                this.setImplClassName(paymentInfo, AllocationPayImpl.class.getName());
            }
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo);
        } else if (this.isPay(paymentInfo)) {
            if (this.isXHJ8016Interface()) {
                this.setImplClassName(paymentInfo, XHJ8016Impl.class.getName());
            } else if (this.isPaymentByAuthorized()) {
                this.setImplClassName(paymentInfo, AuthorizedPayImpl.class.getName());
            } else {
                this.setSubBizType4Pay(paymentInfo);
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e.", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), subBizType));
        }
        return busiImplInfo;
    }

    private void setSubBizType4Pay(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isIndividual(paymentInfo)) {
            if (this.isSameBank(paymentInfo)) {
                this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.hxb.dc.services.payment.individual.outterBank.IndividualPayImpl.class.getName());
            }
        } else if (this.isCompany2use0016()) {
            this.setImplClassName(paymentInfo, InnerBankPayImpl.class.getName());
        } else if (this.isSameBank(paymentInfo)) {
            this.setImplClassName(paymentInfo, InnerBankPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, OutterBankPayImpl.class.getName());
        }
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isSameBank(paymentInfo)) {
            this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
        } else if (this.isSalaryUseCN(paymentInfo)) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.hxb.dc.services.payment.salary.OutterBank.SalaryPayImpl.class.getName());
        } else if (this.otherBankSalaryIsUse8044()) {
            this.setImplClassName(paymentInfo, PayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.hxb.dc.services.payment.individual.outterBank.IndividualPayImpl.class.getName());
        }
    }

    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    private boolean isTransferToCompany() {
        return this.assertBusinessConfig("transferToCompany", "true");
    }

    private boolean isPaymentByAuthorized() {
        return this.assertBusinessConfig("HXB_DC_PAYMENT_MODEL", "payment_authorized");
    }

    private boolean isXHJ8016Interface() {
        return this.assertBusinessConfig("HXB_DC_PAYMENT_MODEL", "payment_single");
    }

    private boolean isCompany2use0016() {
        return this.assertBusinessConfig("hxb_dc_CompanySelect", "2");
    }

    private boolean otherBankSalaryIsUse8044() {
        return this.assertBusinessConfig("HXB_DC_OTHER_SALARY_MODEL", "xhj8044");
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

