/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.company.innerBank;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.company.innerBank.InnerBankQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class InnerBankPayImpl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return InnerBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "xhj0016";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u516c\u540c\u884c\u4ed8\u6b3e", (String)"InnerBankPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay_for_capital_allocation".equalsIgnoreCase(paymentInfo.getSubBizType())) {
            if (paymentInfo.is2SameBank()) {
                return true;
            }
        } else {
            if (BankBusinessConfig.isCompany2use0016()) {
                return true;
            }
            if ("pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2Individual() && paymentInfo.is2SameBank()) {
                return true;
            }
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        if (paymentInfos.size() > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8f6c\u8d26\u4ea4\u6613\uff08\u65b0\u610f\uff09(xhj0016)\u63a5\u53e3\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"InnerBankPayImpl_1", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("xhj0016");
        sb.append('#');
        String testTime = EBContext.getContext().getParameter().getBankParameter("TEST_TIME");
        if (!StringUtils.isEmpty((String)testTime)) {
            sb.append(testTime);
        } else {
            sb.append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        }
        sb.append('#');
        if (paymentInfo.is2SameBank()) {
            sb.append("1");
        } else {
            sb.append("2");
        }
        sb.append('#');
        sb.append(paymentInfo.getPackageId());
        sb.append('#');
        sb.append("9999999999");
        sb.append('#');
        sb.append(paymentInfo.getAccNo());
        sb.append('#');
        sb.append(paymentInfo.getAmount().setScale(2, 5).toString());
        sb.append('#');
        sb.append(paymentInfo.getIncomeAccNo());
        sb.append('#');
        sb.append(paymentInfo.getIncomeAccName());
        sb.append('#');
        sb.append(paymentInfo.getIncomeBankName());
        sb.append('#');
        sb.append(paymentInfo.getIncomeBankAddress());
        sb.append('#');
        if (!StringUtils.isEmpty((String)paymentInfo.getIncomeCnaps())) {
            sb.append(paymentInfo.getIncomeCnaps());
        } else {
            sb.append(" ");
        }
        sb.append('#');
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            if (!StringUtils.isEmpty((String)paymentInfo.getExplanation())) {
                sb.append(Packer.getKDExp(paymentInfo));
            } else {
                sb.append(Packer.getKDExp(paymentInfo, ""));
            }
        } else {
            sb.append(paymentInfo.getExplanation());
        }
        sb.append('#');
        sb.append(" ");
        sb.append('#');
        sb.append(" ");
        sb.append('#');
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        try {
            String responseCode = elements[0];
            String responseMsg = "";
            responseMsg = elements.length > 2 ? String.format(ResManager.loadKDString((String)"\u4f01\u4e1a\u7aef\u6d41\u6c34\u53f7:%1$s;\u5907\u7528\u57df1:%2$s\u3002", (String)"InnerBankPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[1], elements[2]) : String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%s\u3002", (String)"InnerBankPayImpl_12", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[0]);
            if ("000000".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"InnerBankPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else if ("EL4114".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"InnerBankPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u8d26\u53f7\u6216\u5361\u53f7\u65e0\u6548\u3002", (String)"InnerBankPayImpl_8", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"InnerBankPayImpl_9", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMsg);
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%s\u3002", (String)"InnerBankPayImpl_13", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

