/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.salary.OutterBank;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.salary.OutterBank.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class SalaryPayImpl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "xhj2003";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u4ee3\u53d1\u5de5\u8d44", (String)"SalaryPayImpl_0", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymenInfo = paymentInfos[0];
        BigDecimal totalAmt = new BigDecimal("0.00");
        StringBuilder cyc_str = new StringBuilder();
        int totalNum = paymentInfos.length;
        boolean addKDFlagToPay = BankBusinessConfig.isAddKDFlagToPay();
        for (int i = 0; i < paymentInfos.length; ++i) {
            totalAmt = totalAmt.add(paymentInfos[i].getAmount());
            cyc_str.append(i + 1);
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getIncomeCnaps());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getIncomeAccNo());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getIncomeAccName());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getAmount().setScale(2, 5).toString());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getExplanation());
            cyc_str.append("|");
            cyc_str.append('#');
        }
        StringBuilder sb = new StringBuilder();
        sb.append("xhj2003");
        sb.append('#');
        sb.append("9999999999");
        sb.append('#');
        sb.append(paymenInfo.getAccNo());
        sb.append('#');
        sb.append(totalAmt.setScale(2, 5).toString());
        sb.append('#');
        sb.append(totalNum);
        sb.append('#');
        if (addKDFlagToPay) {
            if (!StringUtils.isEmpty((String)paymenInfo.getExplanation())) {
                sb.append(Packer.getKDExp(paymenInfo));
            } else {
                sb.append(Packer.getKDExp(paymenInfo, ""));
            }
        } else {
            sb.append(paymenInfo.getExplanation());
        }
        sb.append('#');
        String str = cyc_str.toString();
        sb.append(str);
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        List paymentInfos = request.getPaymentInfos();
        try {
            String responseCode = elements[0];
            String flow_no = elements[1];
            String responseMsg = "";
            responseMsg = elements.length >= 2 ? String.format(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7:%s", (String)"SalaryPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), flow_no) : String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%s\u3002", (String)"SalaryPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), responseCode);
            if ("000000".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"SalaryPayImpl_4", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)"", (String)"");
                PaymentInfoSysFiled.set((List)paymentInfos, (String)"flow_no", (String)flow_no);
            } else if ("EL4114".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u8d26\u53f7\u6216\u5361\u53f7\u65e0\u6548\u3002", (String)"SalaryPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"SalaryPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMsg);
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%s\u3002", (String)"SalaryPayImpl_12", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

