/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.nyb.dc.service.payment.single;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.nyb.dc.service.payment.single.SingleBankQueryPayImpl;
import kd.ebg.aqap.banks.nyb.dc.service.util.Packer;
import kd.ebg.aqap.banks.nyb.dc.service.util.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleBankPayImpl
extends AbstractPayImpl
implements IPay {
    private static final Logger logger = LoggerFactory.getLogger(SingleBankPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SingleBankQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "DEAL0010";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u8f6c\u8d26", (String)"SingleBankPayImpl_0", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u3002", (String)"SingleBankPayImpl_1", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]));
        }
        Element root = Packer.buildHead(paymentInfos[0].getBankDetailSeqId(), "DEAL0010");
        Element body = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = JDomUtils.addChild((Element)body, (String)"entity");
        JDomUtils.addChild((Element)entity, (String)"payerAccount", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)entity, (String)"payerName", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)entity, (String)"receiveAccount", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)entity, (String)"receiveName", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)entity, (String)"depositCode", (String)paymentInfos[0].getIncomeCnaps());
        JDomUtils.addChild((Element)entity, (String)"tradeMoney", (String)paymentInfos[0].getAmount().toString());
        JDomUtils.addChild((Element)entity, (String)"urgentFlag", (String)(paymentInfos[0].is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)entity, (String)"privateFlag", (String)(paymentInfos[0].is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)entity, (String)"tradeMemo", (String)paymentInfos[0].getExplanation());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = Parser.parser(root);
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"body");
        Element entity = JDomUtils.getChildElement((Element)resBody, (String)"entity");
        String billCode = entity.getChildText("billCode");
        logger.info("\u72b6\u6001:" + bankResponse.getResponseCode());
        ((PaymentInfo)paymentInfos.get(0)).setBankRefID(billCode);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)"000000", (String)ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u63d0\u4ea4\u94f6\u884c\u6210\u529f\u3002", (String)"SingleBankPayImpl_2", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        try {
            String requestStr = this.pack(request);
            String responseStr = Packer.getMessage(requestStr);
            return this.parse(request, responseStr);
        }
        catch (Exception e) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"SingleBankPayImpl_3", (String)"ebg-aqap-banks-nyb-dc", (Object[])new Object[0]), e.getMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }
}

