/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bod.cmp.service.payment.single;

import java.io.InputStream;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bod.cmp.BankBussinessConfig;
import kd.ebg.aqap.banks.bod.cmp.service.Packer;
import kd.ebg.aqap.banks.bod.cmp.service.Parser;
import kd.ebg.aqap.banks.bod.cmp.service.payment.single.SingleQueryPayImpl;
import kd.ebg.aqap.banks.bod.cmp.utils.BOD_CMPUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SinglePayImpl
extends AbstractPayImpl
implements IPay {
    public void configFactory(ConnectionFactory factory) {
        factory.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SingleQueryPayImpl.class;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5bf9\u5916\u652f\u4ed8", (String)"SinglePayImpl_0", (String)"ebg-aqap-banks-bod-cmp", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return BOD_CMPUtils.parseRecvMsg(super.recv(inputStream));
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
            return paymentInfo.getTotalCount() == 1 || !paymentInfo.is2SameBank();
        }
        return false;
    }

    public String pack(BankPayRequest request) {
        PaymentInfo paymentInfo = request.getPaymentInfoAsArray()[0];
        Element root = Packer.createHead("300001", paymentInfo.getPackageId());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"as_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"as_acno", (String)"");
        JDomUtils.addChild((Element)body, (String)"as_acname", (String)"");
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_type", (String)"");
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"rcv_acno", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"rcv_cur_code", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"rcv_acname", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"rcv_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"rcv_bank_no", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"rcv_bank_name", (String)paymentInfo.getIncomeBankName());
        String amount = paymentInfo.getAmount().setScale(2, 1).toString();
        JDomUtils.addChild((Element)body, (String)"amt", (String)amount);
        JDomUtils.addChild((Element)body, (String)"bank_flag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"urgency_flag", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"area_flag", (String)(paymentInfo.is2SameCity() ? "0" : "1"));
        JDomUtils.addChild((Element)body, (String)"bank_kind", (String)"");
        if (BankBussinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            JDomUtils.addChild((Element)body, (String)"purpose", (String)BizNoUtil.cont((String)paymentInfo.getBankDetailSeqID(), (String)paymentInfo.getExplanation()));
        } else {
            JDomUtils.addChild((Element)body, (String)"purpose", (String)paymentInfo.getExplanation());
        }
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_flag", (String)"0");
        JDomUtils.addChild((Element)body, (String)"booking_date", (String)"");
        JDomUtils.addChild((Element)body, (String)"booking_time", (String)"");
        JDomUtils.addChild((Element)body, (String)"saverecvinfo_flag", (String)"");
        JDomUtils.addChild((Element)body, (String)"mobiles", (String)paymentInfo.getMobiles());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return Packer.buildCommonMsg(xmlStr);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parserHead(root);
        if ("0".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

