/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.uob.dc.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.uob.dc.services.Api;
import kd.ebg.aqap.banks.uob.dc.utils.UOBUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public EBBankDetailResponse doBiz(BankDetailRequest request) {
        ArrayList detailList = new ArrayList(16);
        this.setLastPage(false);
        try {
            do {
                EBBankDetailResponse response = this.process(request);
                detailList.addAll(response.getDetails());
            } while (!this.isLastPage());
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse process(BankDetailRequest request) {
        String nextRecords = RequestContextUtils.getRunningParam((String)"nextRecords");
        try {
            EBContext.getContext().setProcessFlag(PROCESS_PACK);
            String requestStr = this.pack(request);
            EBContext.getContext().setProcessFlag(PROCESS_CONNECTED);
            String fromDate = request.getStartDate().format(DateTimeFormatter.ofPattern("ddMMyyyy"));
            String toDate = request.getEndDate().plusDays(1L).format(DateTimeFormatter.ofPattern("ddMMyyyy"));
            String queryParam = StringUtils.isEmpty((String)nextRecords) ? String.format("?fromDate=%s&toDate=%s&fromTime=00:00&toTime=00:00", fromDate, toDate) : String.format("?fromDate=%s&toDate=%s&fromTime=00:00&toTime=00:00&nextRecords=%s", fromDate, toDate, nextRecords);
            String response = UOBUtil.request((HttpRequestBase)new HttpGet(UOBUtil.url(Api.DETAIL.getName() + queryParam)), UOBUtil.generateJWT(requestStr));
            EBContext.getContext().setProcessFlag(PROCESS_PARSE);
            return this.parse(request, response);
        }
        catch (Exception e) {
            EBContext.getContext().setExceptionMsg(e);
            logger.error("\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:" + e.getMessage());
            String errorMsg = ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38\u3002", (String)"DetailImpl_0", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((String)e.getMessage())) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u51fa\u73b0\u5f02\u5e38:%s\u3002", (String)"DetailImpl_1", (String)"ebg-aqap-banks-uob-dc", (Object[])new Object[0]), e.getMessage());
            }
            throw EBExceiptionUtil.serviceException((String)errorMsg, (Throwable)e);
        }
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        JSONObject root = new JSONObject();
        BankAcnt acnt = bankDetailRequest.getAcnt();
        root.put("transactionReference", (Object)Sequence.gen16Sequence());
        JSONObject account = new JSONObject();
        account.put("accountNumber", (Object)acnt.getAccNo());
        account.put("accountCurrency", (Object)bankDetailRequest.getBankCurrency());
        account.put("accountType", (Object)BankAcntPropertyConfig.getAccType((String)acnt.getAccNo()));
        root.put("account", (Object)account);
        String r = root.toJSONString();
        logger.info("Payload\u4e3a{}", (Object)r);
        return r;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        this.setLastPage(true);
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(8);
        BankAcnt bankAcnt = bankDetailRequest.getAcnt();
        JSONObject root = JSONObject.parseObject((String)s);
        JSONObject account = root.getJSONObject("account");
        JSONArray transactions = account.getJSONArray("transactions");
        if (transactions == null || transactions.isEmpty()) {
            return new EBBankDetailResponse(detailInfos);
        }
        String nextRecords = account.getString("nextRecords");
        if (StringUtils.isEmpty((String)nextRecords)) {
            RequestContextUtils.setRunningParam((String)"nextRecords", (String)"");
        } else {
            RequestContextUtils.setRunningParam((String)"nextRecords", (String)nextRecords);
            this.setLastPage(false);
        }
        for (int i = 0; i < transactions.size(); ++i) {
            BigDecimal amount;
            JSONObject transaction = transactions.getJSONObject(i);
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(bankAcnt.getAccNo());
            detailInfo.setAccName(bankAcnt.getAccName());
            String cdFlag = transaction.getString("creditDebitCode");
            if ("C".equalsIgnoreCase(cdFlag)) {
                JSONObject creditAmount = transaction.getJSONObject("creditAmount");
                amount = creditAmount.getBigDecimal("amount");
                detailInfo.setCreditAmount(amount);
                detailInfo.setDebitAmount(BigDecimal.ZERO);
            } else {
                JSONObject debitAmount = transaction.getJSONObject("debitAmount");
                amount = debitAmount.getBigDecimal("amount");
                detailInfo.setDebitAmount(amount);
                detailInfo.setCreditAmount(BigDecimal.ZERO);
            }
            JSONObject ledgerBalance = transaction.getJSONObject("ledgerBalance");
            BigDecimal balance = ledgerBalance.getBigDecimal("amount");
            detailInfo.setBalance(balance);
            String transactionDateTime = transaction.getString("transactionDateTime");
            LocalDateTime dt = LocalDateTime.parse(transactionDateTime, DateTimeFormatter.ofPattern("dd-MM-yyyy'T'HH:mm:ss"));
            detailInfo.setTransTime(dt);
            detailInfo.setTransDate(dt.toLocalDate());
            detailInfo.setJsonMap(transaction.toJSONString());
            String remark = transaction.getString("remarks");
            detailInfo.setExplanation(remark);
            detailInfo.setCurrency(bankDetailRequest.getBankCurrency());
            detailInfos.add(detailInfo);
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

