/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.scbb.dc.services.balance;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.scbb.dc.services.utils.CommonUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HistoryBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element root = new Element("Message");
        JDomUtils.addChild((Element)root, (Element)CommonUtil.buildHead("B2EQryHistoryBalance", Sequence.gen18Sequence()));
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        Element List2 = JDomUtils.addChild((Element)body, (String)"List");
        Element Map2 = JDomUtils.addChild((Element)List2, (String)"Map");
        JDomUtils.addChild((Element)Map2, (String)"AccountNo", (String)accNo);
        JDomUtils.addChild((Element)Map2, (String)"BegDate", (String)LocalDateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)Map2, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyy-MM-dd"));
        JDomUtils.addChild((Element)Map2, (String)"Currency", (String)request.getBankCurrency());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String rspStr) {
        CommonUtil.resSuccessCheck(rspStr);
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element child = root.getChild("Body").getChild("List");
        if (child == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56deList\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"HistoryBalanceImpl_0", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]));
        }
        List list = child.getChildren("Map");
        for (Element element : list) {
            BalanceInfo balanceInfo = new BalanceInfo();
            try {
                String currency = element.getChildText("Currency");
                currency = StringUtils.isEmpty((String)currency) ? request.getBankCurrency() : currency;
                balanceInfo.setBankAcnt(request.getAcnt());
                String date = element.getChildText("Date");
                String currentBalance = element.getChildText("Balance");
                String availableBalance = element.getChildText("AvailBal");
                this.setBankCurrency(balanceInfo, request.getBankCurrency(), currency);
                this.setBalanceDateTime(balanceInfo, date + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                this.setCurrentBalance(balanceInfo, currentBalance);
                this.setAvailableBalance(balanceInfo, availableBalance);
            }
            catch (Exception e) {
                balanceInfo.setError(e.getMessage());
            }
            balanceInfos.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EQryHistoryBalance";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HistoryBalanceImpl_1", (String)"ebg-aqap-banks-scbb-dc", (Object[])new Object[0]);
    }

    public LocalDate limitDate() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        String uri = "/web_eibs/B2EQryHistoryBalance.do?userPassword=" + RequestContextUtils.getParameter().getBankParameter("password") + "&SIGDATA=1";
        factory.setUri(uri);
        super.configFactory(factory);
    }
}

