/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.shrcb.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.shrcb.dc.services.login.LoginImpl;
import kd.ebg.aqap.banks.shrcb.dc.utils.Packer;
import kd.ebg.aqap.banks.shrcb.dc.utils.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String sessionId = new LoginImpl().getSessionID();
        Element root = Packer.createCommonHead("0002", sessionId);
        ArrayList bodyList = new ArrayList();
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>(16);
        param.put("AcctNo", request.getAcnt().getAccNo());
        param.put("AcctCurr", request.getBankCurrency());
        bodyList.add(param);
        Packer.addBody(root, bodyList);
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parserMsgHead(root);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element body = root.getChild("body");
        String accountNo = body.getChildTextTrim("acct_no");
        String accountName = body.getChildTextTrim("acct_name");
        String cur = body.getChildTextTrim("acct_curr");
        String bal = body.getChildTextTrim("balance");
        String availBal = body.getChildTextTrim("available_balance");
        BalanceInfo balance = new BalanceInfo();
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        balances.add(balance);
        this.setBankAcnt(balance, request.getBankAcntList(), accountNo);
        this.setBankCurrency(balance, request.getBankCurrency(), cur);
        balance.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(balance, bal);
        this.setAvailableBalance(balance, availBal);
        EBBankBalanceResponse rsp = new EBBankBalanceResponse();
        rsp.setBalances(balances);
        return rsp;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "0002";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_4", (String)"ebg-aqap-banks-shrcb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/i2sc-client/ClientServlet/client.do");
        factory.setHttpHeader("Content-Encoding", "utf-8");
    }
}

