/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ceb.dc.services.balance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ceb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ceb.dc.utils.BankUtils;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class BatchBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(BatchBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        List bankAcntList = bankBalanceRequest.getBankAcntList();
        Element root = JDomUtils.createRoot((String)"Transaction");
        this.createSystemHead(root, bankBalanceRequest.getAcnt().getAccNo());
        Element transHead = JDomUtils.addChild((Element)root, (String)"TransHead");
        JDomUtils.addChild((Element)transHead, (String)"TransCode", (String)"b2e004031");
        JDomUtils.addChild((Element)transHead, (String)"BatchID", (String)Sequence.gen18Sequence());
        LocalDateTime now = LocalDateTime.now();
        JDomUtils.addChild((Element)transHead, (String)"JnlDate", (String)now.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)transHead, (String)"JnlTime", (String)now.format(DateTimeFormatter.ofPattern("HHmmss")));
        Element transContent = JDomUtils.addChild((Element)root, (String)"TransContent");
        Element reqData1 = JDomUtils.addChild((Element)transContent, (String)"ReqData");
        JDomUtils.addChild((Element)reqData1, (String)"TotalNum", (String)String.valueOf(bankAcntList.size()));
        Element BatchReqList = JDomUtils.addChild((Element)reqData1, (String)"BatchReqList");
        for (BankAcnt acnt : bankAcntList) {
            String accNo = acnt.getAccNo();
            Element reqData = JDomUtils.addChild((Element)BatchReqList, (String)"ReqData");
            JDomUtils.addChild((Element)reqData, (String)"ClientPatchID", (String)Sequence.gen18Sequence());
            JDomUtils.addChild((Element)reqData, (String)"AcNo", (String)accNo);
        }
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public void createSystemHead(Element root, String reqAccNo) {
        String cifNo = BankUtils.getExclusiveCifNo(reqAccNo);
        String operatorID = RequestContextUtils.getBankParameterValue((String)"OperatorID");
        Element systemHead = new Element("SystemHead");
        JDomUtils.addChild((Element)systemHead, (String)"Language", (String)"zh_CN");
        JDomUtils.addChild((Element)systemHead, (String)"Encodeing", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Version", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"ServiceName", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"CifNo", (String)cifNo);
        JDomUtils.addChild((Element)systemHead, (String)"UserID", (String)operatorID);
        JDomUtils.addChild((Element)systemHead, (String)"MAC", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"SyPinFlag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"PinSeed", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"LicenseId", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Flag", (String)"");
        JDomUtils.addChild((Element)systemHead, (String)"Note", (String)"");
        JDomUtils.addChild((Element)root, (Element)systemHead);
    }

    private Map<String, BankAcnt> transMap(List<BankAcnt> bankAcntList) {
        HashMap<String, BankAcnt> map = new HashMap<String, BankAcnt>(16);
        if (bankAcntList != null && bankAcntList.size() > 0) {
            for (BankAcnt bankAcnt : bankAcntList) {
                map.put(bankAcnt.getAccNo(), bankAcnt);
            }
        }
        return map;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        ArrayList<BalanceInfo> balanceInfoList = new ArrayList<BalanceInfo>(16);
        bankBalanceResponse.setBalances(balanceInfoList);
        List bankAcntList = bankBalanceRequest.getBankAcntList();
        Map<String, BankAcnt> bankAcntMap = this.transMap(bankAcntList);
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Namespace namespace = root.getNamespace();
        Element transContent = root.getChild("TransContent", namespace);
        if (null == transContent) {
            String ReturnCode = root.getChildTextTrim("ReturnCode", namespace);
            String ReturnMsg = root.getChildTextTrim("ReturnMsg", namespace);
            String error = root.getChildTextTrim("error", namespace);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u51fa\u9519\uff1a[ReturnCode=%1$s,ReturnMsg=%2$s,error=%3$s]", (String)"BatchBalanceImpl_7", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), ReturnCode, ReturnMsg, error));
        }
        String returnCode = transContent.getChildTextTrim("ReturnCode", namespace);
        String returnMsg = transContent.getChildTextTrim("ReturnMsg", namespace);
        Element BatchRespList = transContent.getChild("BatchRespList", namespace);
        List list = BatchRespList.getChildren("RespData", namespace);
        if (!"0000".equals(returnCode)) {
            this.logger.info("\u4f59\u989d\u67e5\u8be2\u5b58\u5728\u5f02\u5e38:" + StringUtils.catWithSpace((String[])new String[]{returnCode, returnMsg}));
            bankBalanceResponse.setExtData(String.format(ResManager.loadKDString((String)"\u672c\u6279\u6b21\u4f59\u989d\u67e5\u8be2\u5b58\u5728\u5f02\u5e38:%s\u3002", (String)"BatchBalanceImpl_8", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{returnCode, returnMsg})));
        }
        for (int i = 0; i < list.size(); ++i) {
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfoList.add(balanceInfo);
            Element data = (Element)list.get(i);
            String accountNo = data.getChildTextTrim("accountNo", namespace);
            if (StringUtils.isEmpty((String)accountNo)) {
                accountNo = data.getChildTextTrim("AcNo", namespace);
            }
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(accountNo);
            balanceInfo.setBankAcnt(bankAcnt);
            String returnInnerCode = data.getChildTextTrim("returnCode", namespace);
            String returnInnerInfo = data.getChildTextTrim("returnInfo", namespace);
            String currency = data.getChildTextTrim("HUOBDH", namespace);
            balanceInfo.setBankCurrency(StringUtils.isEmpty((String)currency) ? bankBalanceRequest.getBankCurrency() : currency);
            String balance = data.getChildTextTrim("accountBalance", namespace);
            String availableBalance = data.getChildTextTrim("availableBalance", namespace);
            String SRZ1YE = data.getChildTextTrim("SRZ1YE", namespace);
            if (!"0000".equals(returnInnerCode)) {
                balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2\u5f02\u5e38 :%s\u3002", (String)"BatchBalanceImpl_9", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{returnInnerCode, returnInnerInfo})));
                continue;
            }
            if (StringUtils.isEmpty((String)accountNo)) {
                balanceInfo.setError(ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u8d26\u53f7\u4e3a\u7a7a\u3002", (String)"BatchBalanceImpl_3", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                continue;
            }
            if (bankAcntMap.containsKey(accountNo)) {
                balanceInfo.setBankAcnt(bankAcntMap.get(accountNo));
                if (StringUtils.isEmpty((String)balance)) {
                    balanceInfo.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BatchBalanceImpl_4", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]));
                    continue;
                }
                balanceInfo.setCurrentBalance(new BigDecimal(balance));
                balanceInfo.setBalanceDateTime(LocalDateTime.now());
                if (StringUtils.isNotEmpty((String)availableBalance)) {
                    balanceInfo.setAvailableBalance(new BigDecimal(availableBalance));
                }
                if (!StringUtils.isNotEmpty((String)SRZ1YE)) continue;
                balanceInfo.setLastDayAvlBalance(new BigDecimal(SRZ1YE));
                continue;
            }
            balanceInfo.setError(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u8d26\u53f7[%s]\u4e0d\u5b58\u5728\u3002", (String)"BatchBalanceImpl_10", (String)"ebg-aqap-banks-ceb-dc", (Object[])new Object[0]), accountNo));
        }
        return bankBalanceResponse;
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "b2e004031";
    }

    public String getBizDesc() {
        return "b2e004031";
    }

    public int limit() {
        return 10;
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isUseBalance_b2e004031() && !BankUtils.isCashPoolAcnt(request.getAcnt().getAccNo());
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        StringBuilder sb = new StringBuilder();
        sb.append("/ent/b2e004031.do?usrID=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserID"));
        sb.append("&userPassword=");
        sb.append(RequestContextUtils.getBankParameterValue((String)"UserPassword"));
        factory.setUri(sb.toString());
        return factory;
    }
}

