/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ksrcb.dc.services.balance;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TCommon;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TPacker;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String bankRequestSeq = RequestContextUtils.getRequestContext().getBankRequestSeq();
        Element ap = TPacker.createCommonHead("200108", bankRequestSeq);
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"acno", (String)acnt.getAccNo());
        JDomUtils.addChild((Element)body, (String)"cur_code", (String)request.getBankCurrency());
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String charset = EBContext.getContext().getCharsetName();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)charset);
        Element head = ap.getChild("head");
        BankResponse bankResponse = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u539f\u56e0:%1$S,%2$s", (String)"BalanceImpl_2", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
        }
        String tr_acdt = head.getChildTextTrim("tr_acdt");
        String tr_time = head.getChildTextTrim("tr_time");
        Element body = ap.getChild("body");
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(request.getAcnt());
        String balance = "";
        String use_balance = "";
        try {
            balanceInfo.setBalanceDateTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        }
        catch (Exception e) {
            log.warn("\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38{}", new Object[]{e});
        }
        String cur_code = body.getChildTextTrim("cur_code");
        balance = body.getChildTextTrim("balance");
        use_balance = body.getChildTextTrim("use_balance");
        balanceInfo.setBankCurrency(cur_code);
        if (!StringUtils.isEmpty((String)balance)) {
            balanceInfo.setCurrentBalance(new BigDecimal(balance));
        }
        if (!StringUtils.isEmpty((String)use_balance)) {
            balanceInfo.setAvailableBalance(new BigDecimal(use_balance));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"BalanceImpl_1", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

