/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ksrcb.dc.services.payment.batch;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ksrcb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.ksrcb.dc.services.payment.batch.QueryBatchPayImpl;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TCommon;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TPacker;
import kd.ebg.aqap.banks.ksrcb.dc.utils.UploadFrontProxy;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayTypeEnum;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BatchPayImpl
extends AbstractPayImpl
implements IPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(BatchPayImpl.class);

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "300006";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        String bizType = paymentInfo.getSubBizType();
        return !PayTypeEnum.OVERSEA_PAY.getName().equalsIgnoreCase(bizType) && paymentInfo.getTotalCount() > 1;
    }

    public int getBatchSize() {
        return 200;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryBatchPayImpl.class;
    }

    public String pack(BankPayRequest request) {
        StringBuilder sb = new StringBuilder();
        BigDecimal totalAmount = new BigDecimal("0.00");
        List paymentInfos = request.getPaymentInfos();
        sb.append("cert_type").append("|");
        sb.append("cert_no").append("|");
        sb.append("rcv_acno").append("|");
        sb.append("rcv_cur_code").append("|");
        sb.append("rcv_acname").append("|");
        sb.append("rcv_accaddr").append("|");
        sb.append("amt").append("|");
        sb.append("as_flag").append("|");
        sb.append("as_acno").append("|");
        sb.append("as_acname").append("|");
        sb.append("rcv_bank_no").append("|");
        sb.append("rcv_bank_name").append("|");
        sb.append("bank_flag").append("|");
        sb.append("area_flag").append("|");
        sb.append("urgency_flag").append("|");
        sb.append("purpose").append("|");
        sb.append("postscript").append("|");
        sb.append("booking_flag").append("|");
        sb.append("booking_date").append("|");
        sb.append("booking_time").append("|");
        sb.append("mobiles").append("|");
        sb.append("saverecvinfo_flag").append("|");
        sb.append("\r\n");
        boolean addKDFlagToPay = BankBusinessConfig.isAddKDFlagToPay();
        for (int i = 0; i < paymentInfos.size(); ++i) {
            BigDecimal amt = ((PaymentInfo)paymentInfos.get(i)).getAmount();
            totalAmount = totalAmount.add(amt);
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(i);
            sb.append("").append("|");
            sb.append(paymentInfo.getBankDetailSeqId()).append("|");
            sb.append(paymentInfo.getIncomeAccNo()).append("|");
            sb.append(paymentInfo.getCurrency()).append("|");
            sb.append(paymentInfo.getIncomeAccName()).append("|");
            sb.append("|");
            sb.append(amt.toString()).append("|");
            sb.append("0").append("|");
            sb.append("|");
            sb.append("|");
            sb.append(paymentInfo.getIncomeCnaps()).append("|");
            sb.append(paymentInfo.getIncomeBankName()).append("|");
            sb.append(paymentInfo.is2SameBank() ? "0" : "1").append("|");
            sb.append(paymentInfo.is2SameCity() ? "0" : "1").append("|");
            sb.append(paymentInfo.is2Urgent() ? "1" : "0").append("|");
            if (addKDFlagToPay) {
                PaymentUtil.setKdFlagIDByBankBatchSeqID((PaymentInfo)paymentInfo);
                sb.append(paymentInfo.getBankBatchSeqId()).append("KD@").append(paymentInfo.getExplanation()).append("|");
            } else {
                sb.append(paymentInfo.getExplanation()).append("|");
            }
            sb.append("").append("|");
            sb.append("").append("|");
            sb.append("").append("|");
            sb.append("").append("|");
            sb.append("").append("|");
            sb.append("").append("|");
            sb.append("\r\n");
        }
        String tr_code = "300006";
        Element ap = TPacker.createCommonHead(tr_code, ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId(), "1");
        Element body = ap.getChild("body");
        JDomUtils.addChild((Element)body, (String)"batch_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"pay_acno", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)body, (String)"pay_cur_code", (String)((PaymentInfo)paymentInfos.get(0)).getCurrency());
        JDomUtils.addChild((Element)body, (String)"pay_acname", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)body, (String)"pay_accaddr", (String)"");
        JDomUtils.addChild((Element)body, (String)"amt", (String)totalAmount.setScale(2, 1).toPlainString());
        JDomUtils.addChild((Element)body, (String)"count", (String)(paymentInfos.size() + ""));
        JDomUtils.addChild((Element)body, (String)"purpose", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)body, (String)"postscript", (String)"");
        JDomUtils.addChild((Element)body, (String)"delay_flag", (String)"0");
        String fileName = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId() + ".dat";
        JDomUtils.addChild((Element)body, (String)"file_name", (String)fileName);
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)EBContext.getContext().getCharsetName());
        try {
            log.info("\u5f00\u59cb\u4e0a\u4f20\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u6587\u4ef6\uff0c\u6587\u4ef6\u540d:{}", (Object)fileName);
            UploadFrontProxy uploadFrontProxy = new UploadFrontProxy();
            uploadFrontProxy.setFileContent(sb.toString());
            uploadFrontProxy.doBiz(fileName);
            log.info("\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff0c\u6587\u4ef6\u5185\u5bb9:{}", (Object)sb.toString());
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u3010\u6279\u91cf\u5bf9\u5916\u652f\u4ed8\u3011\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\u3002", (String)"BatchPayImpl_0", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (Throwable)e);
        }
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        Element ap = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element head = ap.getChild("head");
        BankResponse bankResponse = TCommon.parseBankResponse(head);
        List paymentInfos = request.getPaymentInfos();
        if ("0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"BatchPayImpl_1", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"BatchPayImpl_2", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

