/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ksrcb.dc.services.payment.company;

import java.io.InputStream;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TCommon;
import kd.ebg.aqap.banks.ksrcb.dc.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CompanyQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "200205";
    }

    public String getBizDesc() {
        return null;
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest request) {
        String tr_code = "200205";
        Element ap = TPacker.createCommonHead(tr_code, Sequence.genSequence());
        Element body = ap.getChild("body");
        List paymentInfos = request.getPaymentInfos();
        JDomUtils.addChild((Element)body, (String)"cert_no", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"req_no", (String)"");
        String date = ((PaymentInfo)paymentInfos.get(0)).getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String testTime = RequestContextUtils.getBankParameterValue((String)"time_for_test");
        if (!StringUtils.isEmpty((String)testTime)) {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)testTime);
        } else {
            JDomUtils.addChild((Element)body, (String)"tr_acdt", (String)date);
        }
        String xmlMsg = JDomUtils.root2StringWithoutXMLDeclaration((Element)ap, (String)RequestContextUtils.getCharset());
        return TCommon.createCommonMsg(xmlMsg);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element ap = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element head = ap.getChild("head");
        BankResponse bankResponse = TCommon.parseBankResponse(head);
        if (!"0_0000".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        Element body = ap.getChild("body");
        String stat = body.getChildTextTrim("stat");
        String error_info = body.getChildTextTrim("error_info");
        String retMsg = String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7ed3\u679c[\u72b6\u6001:%1$s;\u8bf4\u660e\u4fe1\u606f:%2$s]", (String)"CompanyQueryPayImpl_6", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), stat, error_info);
        if ("9".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CompanyQueryPayImpl_2", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]));
        } else if ("1".equals(stat) || "6".equals(stat) || "7".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CompanyQueryPayImpl_3", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)retMsg);
        } else if ("0".equals(stat) || "2".equals(stat) || "3".equals(stat) || "4".equals(stat) || "5".equals(stat) || "A".equals(stat) || "C".equals(stat) || "D".equals(stat) || "E".equals(stat)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"CompanyQueryPayImpl_4", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)retMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"CompanyQueryPayImpl_5", (String)"ebg-aqap-banks-ksrcb-dc", (Object[])new Object[0]), (String)stat, (String)retMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String recv(InputStream inputStream) {
        return TCommon.parseRecvMsg(super.recv(inputStream));
    }
}

