/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.dbs.hkn.services.DBS_DC_Packer;
import kd.ebg.aqap.banks.dbs.hkn.services.DBS_DC_Parser;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.DbsHelper;
import kd.ebg.aqap.banks.dbs.hkn.services.utils.PgpHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);

    public EBBankBalanceResponse balance(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String rspStr = DbsHelper.sendRequestAndReceive(RequestContextUtils.getBankParameterValue((String)"balanceUri"), acnt.getAccNo(), this.pack(request));
        return this.parse(request, rspStr);
    }

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt acnt = bankBalanceRequest.getAcnt();
        JSONObject header = DBS_DC_Packer.createHeader(acnt.getAccNo(), acnt.getCountry());
        JSONObject txnInfo = new JSONObject();
        txnInfo.put("txnType", (Object)"BLE");
        JSONObject accountBalInfo = new JSONObject();
        accountBalInfo.put("accountNo", (Object)acnt.getAccNo());
        accountBalInfo.put("accountCcy", (Object)bankBalanceRequest.getBankCurrency());
        JSONObject total = new JSONObject();
        total.put("header", (Object)header);
        total.put("txnInfo", (Object)txnInfo);
        total.put("accountBalInfo", (Object)accountBalInfo);
        try {
            return PgpHelper.encry(total.toJSONString());
        }
        catch (Throwable e) {
            this.logger.error("pgp\u52a0\u5bc6\u51fa\u73b0\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"pgp\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), (Throwable)e);
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        String origin;
        try {
            origin = PgpHelper.decry(rspStr);
        }
        catch (Throwable e) {
            this.logger.error("pgp\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38", e);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u5bc6\u9a8c\u7b7e\u65f6\u53d1\u751f\u5f02\u5e38:%s", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        BalanceInfo info = this.parseInfo(origin, bankBalanceRequest);
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{info}));
    }

    public BalanceInfo parseInfo(String origin, BankBalanceRequest bankBalanceRequest) {
        JSONObject total = JSONObject.parseObject((String)origin);
        DBS_DC_Parser.checkError(total);
        JSONObject accountBalResponse = total.getJSONObject("accountBalResponse");
        String enqStatus = accountBalResponse.getString("enqStatus");
        if (!"ACSP".equals(enqStatus)) {
            String enqStatusDescription = accountBalResponse.getString("enqStatusDescription");
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)enqStatus, (String)enqStatusDescription));
        }
        String clsLedgerBal = accountBalResponse.getString("clsLedgerBal");
        String clsAvailableBal = accountBalResponse.getString("clsAvailableBal");
        BalanceInfo info = new BalanceInfo();
        info.setBankCurrency(bankBalanceRequest.getBankCurrency());
        info.setBankAcnt(bankBalanceRequest.getAcnt());
        this.setCurrentBalance(info, clsLedgerBal);
        this.setAvailableBalance(info, clsAvailableBal);
        info.setBalanceDateTime(LocalDateTime.now());
        return info;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

