/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.dbs.hkn.services.utils;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.security.manage.AESCipherSecurity;
import kd.ebg.egf.common.framework.security.manage.CipherInfo;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.apache.commons.codec.binary.Base64;

public class GetKeyStoreHelper {
    public static String getPgpPrivateKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("custom_pgp_pri_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u5ba2\u6237pgp\u79c1\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u79c1\u94a5", (String)"GetKeyStoreHelper_0", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetKeyStoreHelper.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetKeyStoreHelper.getKey(fileContent);
    }

    public static String getPgpPublicKey() {
        UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
        CertInfo certInfo = userCertRepository.findBankLoginCertByBankLoginIDAndBankConfigIDAndCustomID("dbs_pgp_pub_key", RequestContextUtils.getRequestContext().getBankLoginID(), RequestContextUtils.getRequestContext().getCustomID());
        if (certInfo == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u661f\u5c55\u94f6\u884cpgp\u516c\u94a5\u5931\u8d25\uff0c\u8bf7\u5148\u5230\u524d\u7f6e\u673a\u914d\u7f6e\u9875\u9762\u914d\u7f6e\u516c\u94a5", (String)"GetKeyStoreHelper_1", (String)"ebg-aqap-banks-dbs-hkn", (Object[])new Object[0]));
        }
        CipherInfo cipherInfo = GetKeyStoreHelper.getCipherInfo(certInfo.getFileContent());
        byte[] fileContent = DesUtil.decryptProxyCert((byte[])cipherInfo.getFileBytes(), (String)certInfo.getCustomID(), (int)cipherInfo.getCipherVersion(), (String)certInfo.getCertID());
        return GetKeyStoreHelper.getKey(fileContent);
    }

    private static CipherInfo getCipherInfo(String data) {
        AESCipherSecurity security = (AESCipherSecurity)SpringContextUtil.getBean(AESCipherSecurity.class);
        CipherInfo cipherInfo = security.getCipherInfo(data);
        if (cipherInfo.getCipherVersion() == 0) {
            cipherInfo.setFileBytes(java.util.Base64.getDecoder().decode(cipherInfo.getCipherData()));
        } else {
            cipherInfo.setFileBytes(Base64.decodeBase64((String)cipherInfo.getCipherData()));
        }
        return cipherInfo;
    }

    private static String getKey(byte[] fileContent) {
        return StringUtils.byteToString((byte[])fileContent);
    }
}

