/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.jnb.dc.service.payment.company;

import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.jnb.dc.service.Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 10;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "B2EBatchTrsResQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u652f\u4ed8\u7ed3\u679c\u540c\u6b65", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        Element root = JDomUtils.createRoot((String)"Message");
        Element head = JDomUtils.addChild((Element)root, (String)"Head");
        JDomUtils.addChild((Element)head, (String)"TransCode", (String)"B2EBatchTransferResQry");
        JDomUtils.addChild((Element)head, (String)"ERPTrsTimestamp", (String)LocalDateTime.now().format(Packer.DATE_TIME_SEPARATION_FORMATTER));
        JDomUtils.addChild((Element)head, (String)"ERPJnlNo", (String)Sequence.genSequence());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"HistoryERPJnlNo", (String)request.getBankBatchSeqID());
        return JDomUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element error = root.getChild("error");
        if (null != error) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)"", (String)error.getTextTrim());
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("Head");
        String iBSReturnCode = head.getChildTextTrim("IBSReturnCode");
        String iBSReturnMsg = head.getChildTextTrim("IBSReturnMsg");
        if (!"000000".equals(iBSReturnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)iBSReturnCode, (String)iBSReturnMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        Element body = root.getChild("Body");
        Element list = body.getChild("List");
        if (null == list || list.getChildren() == null || list.getChildren().size() < 1) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        List maps = list.getChildren();
        for (int i = 0; i < maps.size(); ++i) {
            Element map = (Element)maps.get(i);
            String returnCode = map.getChildTextTrim("ReturnCode");
            String returnMsg = map.getChildTextTrim("ReturnMsg");
            String transferJnlNo = map.getChildTextTrim("TransferJnlNo");
            PaymentInfo paymentInfo = EBGBusinessUtils.selectPaymentInfo((List)paymentInfos, (String)transferJnlNo);
            if (null == paymentInfo) continue;
            if ("000000".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("000001".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("000002".equals(returnCode) || "000004".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryPayImpl_5", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            if ("000003".equals(returnCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryPayImpl_6", (String)"ebg-aqap-banks-jnb-dc", (Object[])new Object[0]), (String)returnCode, (String)returnMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

