/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.payment.batch;

import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.services.payment.batch.QueryBatchDetailPayImpl;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.banks.cexim.dc.util.PaymentUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class QueryBatchPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1000;
    }

    public String pack(BankPayRequest request) {
        LoginUtils.login();
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element headr = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)headr);
        Element req = CommonPacker.packPayComEntity(info.getBankBatchSeqId());
        body.addContent((Content)req);
        JDomExtUtils.addChildCDData(req, "Enqr_StDt", info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(req, "Enqr_CODt", info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomExtUtils.addChildCDData(req, "Enqr_Dt_TpCd", "2");
        JDomExtUtils.addChildCDData(req, "CstPty_Py_Jrnl_No", PaymentUtils.getKDByBatch(info));
        return JDomExtUtils.root2String((Element)root, (String)EBContext.getContext().getCharsetName());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(responseStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"QueryBatchPayImpl_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        responseStr = bankResponse.getBankMsg();
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d\uff0c\u6216\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7ed3\u679c\uff0c\u8bf7\u8054\u7cfb\u94f6\u884c\u786e\u8ba4\u4ea4\u6613\u7ed3\u679c\u3002", (String)"QueryBatchPayImpl_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        String recNum = JDomExtUtils.getChildText((Element)response, (String)"Rvl_Rcrd_Num");
        if (!"0".equalsIgnoreCase(recNum)) {
            List resultList = response.getChildren("LIST1");
            Map<String, CEXIMDCBankResponse> bankResponse1 = CommonParser.getParseredPayStatus(resultList);
            CEXIMDCBankResponse resultCode = bankResponse1.get(PaymentUtils.getKD((PaymentInfo)paymentInfos.get(0)));
            if (null == resultCode) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u7ed3\u679c\u660e\u7ec6", (String)"QueryBatchPayImpl_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (String)"", (String)"");
            } else if ("1".equals(resultCode.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)"", (String)resultCode.getResponseCode(), (String)"");
            } else if ("3".equals(resultCode.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)resultCode.getResponseCode(), (String)resultCode.getBankMsg());
            } else if ("2".equals(resultCode.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)resultCode.getResponseCode(), (String)resultCode.getBankMsg());
            } else if ("4".equals(resultCode.getResponseCode())) {
                new QueryBatchDetailPayImpl().doBiz(request);
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)resultCode.getResponseCode(), (String)resultCode.getBankMsg());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u96c6\u4e3a\u7a7a\u4ea4\u6613\u7ed3\u679c\u672a\u77e5\u3002", (String)"QueryBatchPayImpl_3", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSET43";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4eba\u6c11\u5e01\u6279\u91cf\u4ed8\u6b3e\u4ea4\u6613\u7ed3\u679c\u6c47\u603b\u4fe1\u606f", (String)"QueryBatchPayImpl_4", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }
}

