/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.services.payment.single;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.services.login.LoginUtils;
import kd.ebg.aqap.banks.cexim.dc.services.payment.single.QuerySinglePayImpl;
import kd.ebg.aqap.banks.cexim.dc.util.CEXIMDCBankResponse;
import kd.ebg.aqap.banks.cexim.dc.util.CommonPacker;
import kd.ebg.aqap.banks.cexim.dc.util.CommonParser;
import kd.ebg.aqap.banks.cexim.dc.util.JDomExtUtils;
import kd.ebg.aqap.banks.cexim.dc.util.PaymentUtils;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.LocalDateUtil;
import org.jdom2.Content;
import org.jdom2.Element;

public class SinglePayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QuerySinglePayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        LoginUtils.login();
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element root = new Element("Transaction");
        Element body = JDomExtUtils.addChild((Element)root, (String)"Transaction_Body");
        Element header = CommonPacker.createSystemHead(this.getBizCode());
        root.addContent((Content)header);
        Element request = CommonPacker.packPayComEntity(paymentInfo.getBatchSeqID());
        body.addContent((Content)request);
        JDomExtUtils.addChildCDData(request, "Pyr_BkCgyCd", "01");
        JDomExtUtils.addChildCDData(request, "Pyr_Cst_AccNo", paymentInfo.getAccNo());
        JDomExtUtils.addChildCDData(request, "Pyr_AccNm", paymentInfo.getAccName());
        JDomExtUtils.addChildCDData(request, "RcvPrt_BkCgyCd", paymentInfo.is2SameBank() ? "01" : "02");
        JDomExtUtils.addChildCDData(request, "RcvPrt_Cst_AccNo", paymentInfo.getIncomeAccNo());
        JDomExtUtils.addChildCDData(request, "RcvPtAc_Nm", paymentInfo.getIncomeAccName());
        JDomExtUtils.addChildCDData(request, "RcvPrt_BnkCD", paymentInfo.getIncomeCnaps());
        JDomExtUtils.addChildCDData(request, "RcvPrt_Adr", paymentInfo.getIncomeBankAddress());
        JDomExtUtils.addChildCDData(request, "Rmrk", paymentInfo.getExplanation());
        JDomExtUtils.addChildCDData(request, "Rqs_Amt", paymentInfo.getAmount().toString());
        JDomExtUtils.addChildCDData(request, "Py_Cnd_TpCd", "00");
        JDomExtUtils.addChildCDData(request, "RvPy_ExMd_Cd", "0");
        JDomExtUtils.addChildCDData(request, "Cst_Dlv_Dt", LocalDateUtil.formatDate((LocalDate)LocalDate.now(), (String)"yyyyMMdd"));
        JDomExtUtils.addChildCDData(request, "Cst_Dlv_Tm", LocalDateUtil.formatDate((LocalDateTime)LocalDateTime.now(), (String)"hhmmssSSS"));
        String kdFlag = PaymentUtils.getKD(paymentInfo);
        JDomExtUtils.addChildCDData(request, "CstPty_Py_Jrnl_No", kdFlag);
        return JDomExtUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        CEXIMDCBankResponse bankResponse = CommonParser.getFrontResponse(responseStr);
        if (!bankResponse.isSuccess()) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u91d1\u8776\u524d\u7f6e\u673a\u8fd4\u56de\u5f02\u5e38\u3002%s", (String)"SinglePayImpl_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), bankResponse.getResponseCode() + bankResponse.getResponseMessage()));
        }
        responseStr = bankResponse.getBankMsg();
        EBBankPayResponse ebBankPayResponse = new EBBankPayResponse();
        List paymentInfos = request.getPaymentInfos();
        CEXIMDCBankResponse bankResp = CommonParser.getBankPreResponse(responseStr);
        if (!bankResp.isSuccess()) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)"", (String)bankResp.getResponseCode(), (String)bankResp.getResponseMessage());
            return ebBankPayResponse;
        }
        Element root = JDomExtUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Element body = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Body");
        Element response = JDomExtUtils.getChildElement((Element)body, (String)"response");
        Element head = JDomExtUtils.getChildElement((Element)root, (String)"Transaction_Header");
        String headCode = JDomExtUtils.getChildText((Element)head, (String)"SYS_TX_STATUS");
        String bankMsg = "";
        String bankCode = "";
        if (null != response) {
            bankMsg = JDomExtUtils.getChildText((Element)response, (String)"Err_Inf");
            bankCode = JDomExtUtils.getChildText((Element)response, (String)"CshMgt_Err_Cd");
        } else {
            bankMsg = bankResp.getBankMsg();
            bankCode = bankResp.getResponseCode();
        }
        if ("00".equalsIgnoreCase(headCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankCode, (String)bankMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankCode, (String)bankMsg);
        }
        ebBankPayResponse.setPaymentInfos(paymentInfos);
        return ebBankPayResponse;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "P1CMSET35";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4eba\u6c11\u5e01\u5355\u7b14\u4ed8\u6b3e", (String)"SinglePayImpl_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return PaymentUtils.isCompany(paymentInfo) && paymentInfo.getTotalCount() == 1;
    }
}

