/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cexim.dc.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cexim.dc.util.FileInfoNode;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.impl.AbstractImpl;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.apache.commons.codec.binary.Base64;
import org.jdom2.Element;

public class FileUtils
extends AbstractImpl {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(FileUtils.class);
    public static String SEPARATOR = "|@|";
    private static String uploadFile = "upload";
    public static String LINESEPARTOR = "\n";

    public FileInfoNode getFileInfoNodes(List<PaymentInfo> infos) {
        FileInfoNode node = new FileInfoNode();
        if (null != infos && infos.size() > 0) {
            String content = this.packFileContent(infos);
            node.setFileContent(content);
            try {
                String md5 = this.getMD5(content, "GBK");
                logger.info("\u8fdb\u51fa\u53e3\u94f6\u884c\u6587\u4ef6md5={}", (Object)md5);
                node.setMd5(md5);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("\u5b57\u7b26\u96c6\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            }
            node.setFileName(infos.get(0).getBankBatchSeqID() + ".txt");
        }
        return node;
    }

    public String uploadFile(String bizSeqId, FileInfoNode fileInfoNode) {
        try {
            String rqstStr = this.packUplaodFileXML(fileInfoNode);
            String rspStr = this.sendAndRecvMsg(rqstStr, bizSeqId);
            return this.parseUplaodFileXML(rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String packFileContent(List<PaymentInfo> infos) {
        int size = infos.size() - 1;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(infos.get(i).getDetailSeqId());
            sb.append(SEPARATOR);
            sb.append(infos.get(i).getIncomeAccNo());
            sb.append(SEPARATOR);
            sb.append(infos.get(i).getIncomeAccName());
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(infos.get(i).is2SameBank() ? "01" : "02");
            sb.append(SEPARATOR);
            sb.append(infos.get(i).getAmount().toString());
            this.appends(sb, 42, SEPARATOR);
            sb.append(infos.get(i).getExplanation());
            sb.append(SEPARATOR);
            sb.append(SEPARATOR);
            sb.append(LINESEPARTOR);
        }
        return sb.toString();
    }

    private void appends(StringBuilder sb, int size, String val) {
        for (int i = 0; i < size; ++i) {
            sb.append(val);
        }
    }

    public String getMD5(String s, String encoding) throws UnsupportedEncodingException {
        if (StringUtils.isEmpty((String)s)) {
            return null;
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (md5 != null) {
            md5.update(s.getBytes(encoding));
        }
        StringBuilder sb = new StringBuilder();
        if (md5 != null) {
            for (byte b : md5.digest()) {
                sb.append(String.format("%02X", b));
            }
        }
        return sb.toString().toLowerCase(Locale.ENGLISH);
    }

    public String packUplaodFileXML(FileInfoNode fileInfoNode) {
        Element simulator = JDomUtils.createRoot((String)"frontProxyRequst");
        Element head = FileUtils.createHead(uploadFile);
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        JDomUtils.addChild((Element)body, (String)"bankMsg", (String)"");
        JDomUtils.addChild((Element)body, (String)"fileName", (String)fileInfoNode.getFileName());
        JDomUtils.addChild((Element)body, (String)"bankFile", (String)fileInfoNode.getFileContent());
        return JDomUtils.root2String((Element)simulator, (String)EBContext.getContext().getCharsetName());
    }

    public static Element createHead(String bizType) {
        return FileUtils.createHead(bizType, Sequence.genSequence());
    }

    public static Element createHead(String bizType, String seqno) {
        Element head = new Element("header");
        JDomUtils.addChild((Element)head, (String)"sequence", (String)seqno);
        JDomUtils.addChild((Element)head, (String)"type", (String)bizType);
        return head;
    }

    public String sendAndRecvMsg(String rqstStr, String bizSeqId) {
        String rspStr = "";
        try {
            ConnectionFactory connectionFactory = this.getConnectionFactory();
            IConnection conn = this.getFrontProxyConnection(connectionFactory);
            this.openConnection(conn);
            try (OutputStream os = this.getOutputStream(conn);){
                this.send(os, rqstStr);
                try (InputStream is = this.getInputStream(conn);){
                    rspStr = this.recv(is);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        return rspStr;
    }

    public String parseUplaodFileXML(String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)EBContext.getContext().getCharsetName());
        BankResponse rsp = FileUtils.parseHeader(root);
        if ("0001".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5f02\u5e38 ,%1$s %2$s", (String)"FileUtils_0", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElementNotNull((Element)root, (String)"body");
        String bankMsg = null;
        try {
            byte[] content = Base64.decodeBase64((String)JDomUtils.getChildText((Element)body, (String)"bankMsg"));
            bankMsg = new String(content, EBContext.getContext().getCharsetName());
        }
        catch (UnsupportedEncodingException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u8282\u70b9bankMsg\u53d1\u751f\u5f02\u5e38", (String)"FileUtils_1", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), (Throwable)e);
        }
        String[] strs = StringUtils.split((String)bankMsg, (String)"|");
        String flag = strs[0];
        String errorCodeString = strs[1];
        String errorMsg = strs[2];
        String fileMsg = strs[3];
        if (!"SUCCESS".equalsIgnoreCase(flag)) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25 ,%1$s %2$s", (String)"FileUtils_2", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]), errorCodeString, errorMsg));
        }
        return fileMsg;
    }

    public static BankResponse parseHeader(Element root) {
        Element Head = JDomUtils.getChildElementNotNull((Element)root, (String)"header");
        String IBSReturnCode = JDomUtils.getChildTextNotNull((Element)Head, (String)"returnCode", (String)ResManager.loadKDString((String)"\u54cd\u5e94\u7801", (String)"FileUtils_3", (String)"ebg-aqap-banks-cexim-dc", (Object[])new Object[0]));
        String IBSReturnMsg = JDomUtils.getChildTextNullAsBlank((Element)Head, (String)"returnMsg");
        BankResponse response = new BankResponse();
        response.setResponseCode(IBSReturnCode);
        response.setResponseMessage(IBSReturnMsg);
        return response;
    }
}

