/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.formplugin.service.biz;

import com.alibaba.fastjson.JSONException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.entity.base.EBHeader;
import kd.ebg.egf.common.entity.service.EBServiceRequest;
import kd.ebg.egf.common.entity.service.EBServiceResponse;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.frame.Sequence;
import kd.ebg.egf.formplugin.exception.EBBizException;
import kd.ebg.egf.formplugin.plugin.util.JsonUtil;
import kd.ebg.egf.formplugin.service.model.ParamRequest;
import kd.ebg.egf.formplugin.service.model.ParamRequestBody;
import kd.ebg.egf.formplugin.service.model.ParamResponse;
import kd.ebg.egf.formplugin.service.model.ParamResponseBody;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizService {
    private Logger logger = LoggerFactory.getLogger(BizService.class);
    private static final String ebg_params_cache_start_str = "note_ebg_params_";
    private static BizService instance = new BizService();

    public static BizService getInstance() {
        return instance;
    }

    public ParamResponseBody getEbgParam(String customerID, String bankVersionID) {
        String key = ebg_params_cache_start_str + bankVersionID;
        if (CosmicCache.cosmicCache.contains(key)) {
            String resultStr = (String)CosmicCache.cosmicCache.get(key);
            ParamResponseBody body = JsonUtil.fromJson(resultStr, ParamResponseBody.class);
            return body;
        }
        ParamRequest request = new ParamRequest();
        ParamRequestBody body = new ParamRequestBody();
        request.setBody(body);
        EBHeader header = new EBHeader();
        request.setHeader(header);
        header.setBizType("ebgParam");
        header.setSubBizType("ebgParam");
        header.setClientName("EBG-NOTE");
        header.setCustomId(customerID);
        header.setClientVersion("1.0");
        header.setRequestTime(System.currentTimeMillis());
        String bizSeqID = Sequence.gen18Sequence();
        JSONObject object = new JSONObject();
        object.put((Object)"loggerBatchNo", (Object)bizSeqID);
        object.put((Object)"loggerDetailNo", (Object)bizSeqID);
        object.put((Object)"loggerBankNo", (Object)bizSeqID);
        header.setExtData(object.toString());
        body.setBankVersionName(bankVersionID);
        EBServiceRequest serviceRequest = new EBServiceRequest();
        serviceRequest.setBizType(request.getHeader().getBizType());
        serviceRequest.setCustomerID("EBG-NOTE");
        serviceRequest.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        serviceRequest.setCustomerID(request.getHeader().getCustomId());
        serviceRequest.setData(JsonUtil.toJson(request, true));
        serviceRequest.setVersion("1.0");
        String json = JsonUtil.toJson(serviceRequest, true);
        try {
            String response = (String)DispatchServiceHelper.invokeBizService((String)"ebg", (String)"aqap", (String)"aqapService", (String)"aqapService", (Object[])new Object[]{json});
            ApiResult apiResult = JsonUtil.fromJson(response, ApiResult.class);
            Object dataObj = apiResult.getData();
            if (dataObj == null) {
                throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u54cd\u5e94\u8fd4\u56de\u4e3a\u7a7a\u3002%s", (String)"BizService_1", (String)"ebg-note-formplugin", (Object[])new Object[0]), apiResult.getMessage()));
            }
            String data = JsonUtil.toJson(dataObj);
            EBServiceResponse ebServiceResponse = JsonUtil.fromJson(data, EBServiceResponse.class);
            if (!"success".equals(ebServiceResponse.getResponseCode()) && StringUtils.isEmpty((String)ebServiceResponse.getData())) {
                throw new EBServiceException(ebServiceResponse.getResponseMsg());
            }
            ParamResponse paramResponse = JsonUtil.fromJson(ebServiceResponse.getData(), ParamResponse.class);
            if (paramResponse != null) {
                if (paramResponse.getException() != null) {
                    throw new EBBizException(paramResponse.getException().getMessage());
                }
                ParamResponseBody result = paramResponse.getBody();
                CosmicCache.cosmicCache.put(key, (Object)JsonUtil.toJson(result), 86400);
                return result;
            }
            throw new EBServiceException(ResManager.loadKDString((String)"json\u8f6c\u5bf9\u8c61\u540e\u7ed3\u679c\u4e3a\u7a7a\u3002", (String)"BizService_2", (String)"ebg-note-formplugin", (Object[])new Object[0]));
        }
        catch (JSONException e) {
            throw new EBBizException(e);
        }
    }
}

