/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.codeless.PackerUtil;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.egf.common.codeless.PackerUtil.DataUtil;
import kd.ebg.egf.common.codeless.PackerUtil.FroxyImpl;
import kd.ebg.egf.common.codeless.PackerUtil.JDomExtUtils;
import kd.ebg.egf.common.codeless.services.FuncNameRelection;
import kd.ebg.egf.common.codeless.services.Function;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.service.codeless.CodeLessService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.codeless.CodeLess;
import kd.ebg.egf.common.model.codeless.CodeLessRequestBody;
import kd.ebg.egf.common.model.codeless.CodeLessRequestFileCont;
import kd.ebg.egf.common.model.codeless.CodeLessRequestFileName;
import kd.ebg.egf.common.model.codeless.JudgingCondition1;
import kd.ebg.egf.common.model.codeless.JudgingConditionBody;
import kd.ebg.egf.common.model.codeless.JudgingConditionValue;
import kd.ebg.egf.common.model.codeless.JudgingConditions;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Value;
import org.jdom2.Element;

public class PackerCommon {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(PackerCommon.class);
    private static final String SPLIT = " ";

    public static String packerCommon(List<Map<String, String>> dataList, Map<String, String> map, String structId, String bizType) {
        logger.info("\u5f53\u524d\u63a5\u53e3structId\uff1a" + structId);
        EBContext context = EBContext.getContext();
        String bankVersion = context.getBankVersionID();
        CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCode(bankVersion, bizType, structId);
        context.setCodeLess(codeLess);
        if ("xml".equals(codeLess.getContentType())) {
            return PackerCommon.packerXml(dataList, codeLess, map, false);
        }
        if ("json".equals(codeLess.getContentType())) {
            return PackerCommon.packerJson(dataList, codeLess, map);
        }
        return PackerCommon.packerXml(dataList, codeLess, map, true);
    }

    public static String packerCommonByApp(List<Map<String, String>> dataList, Map<String, String> map, String structId, String bizType, String app) {
        logger.info("\u5f53\u524d\u63a5\u53e3structId\uff1a" + structId);
        EBContext context = EBContext.getContext();
        String bankVersion = context.getBankVersionID();
        CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCodeAndApp(bankVersion, bizType, structId, app);
        context.setCodeLess(codeLess);
        if ("xml".equals(codeLess.getContentType())) {
            return PackerCommon.packerXml(dataList, codeLess, map, false);
        }
        if ("json".equals(codeLess.getContentType())) {
            return PackerCommon.packerJson(dataList, codeLess, map);
        }
        return PackerCommon.packerXml(dataList, codeLess, map, true);
    }

    public static String packerJson(List<Map<String, String>> dataList, CodeLess codeLess, Map<String, String> map) {
        List<CodeLessRequestBody> requestBodys = codeLess.getRequestBodys();
        if (requestBodys == null || requestBodys.size() < 1) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"json\u7ed3\u6784\u7ef4\u62a4\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5id= %s", (String)"PackerUtil_12", (String)"ebg-note-business", (Object[])new Object[0]), codeLess.getNumber()));
        }
        if (codeLess.getFileUpload().booleanValue()) {
            String fileName = PackerCommon.getFileName(codeLess, map, dataList);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u540d\uff1a" + fileName);
            String fileContent = PackerCommon.getFileContent(codeLess, map, dataList);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\uff1a\r\n " + fileContent);
            String fileInfoNode = new FroxyImpl().uploadFile(dataList.get(0).get(""), fileName, fileContent, codeLess.getFileBizType());
            map.put("fileName", fileInfoNode);
            map.put("fileContent", fileContent);
            try {
                map.put("MD5", FroxyImpl.getMD5(fileContent, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.info("\u83b7\u53d6\u6587\u4ef6MD5\u5931\u8d25" + e.getMessage());
                throw EBExceiptionUtil.serviceException(e);
            }
            return PackerCommon.getJson(requestBodys, map, dataList);
        }
        return PackerCommon.getJson(requestBodys, map, dataList);
    }

    public static String packerXml(List<Map<String, String>> dataList, CodeLess codeLess, Map<String, String> map, boolean isTag) {
        List<CodeLessRequestBody> requestBodys = codeLess.getRequestBodys();
        if (requestBodys == null || requestBodys.size() < 1) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"xml\u7ed3\u6784\u7ef4\u62a4\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5id= %s", (String)"PackerUtil_6", (String)"ebg-note-business", (Object[])new Object[0]), codeLess.getNumber()));
        }
        if (codeLess.getFileUpload().booleanValue()) {
            String fileName = PackerCommon.getFileName(codeLess, map, dataList);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u540d\uff1a" + fileName);
            String fileContent = PackerCommon.getFileContent(codeLess, map, dataList);
            logger.info("\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\uff1a\r\n " + fileContent);
            String fileInfoNode = new FroxyImpl().uploadFile(dataList.get(0).get(""), fileName, fileContent, codeLess.getFileBizType());
            map.put("fileName", fileInfoNode);
            map.put("fileContent", fileContent);
            try {
                map.put("MD5", FroxyImpl.getMD5(fileContent, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.info("\u83b7\u53d6\u6587\u4ef6MD5\u5931\u8d25" + e.getMessage());
                throw EBExceiptionUtil.serviceException(e);
            }
            return PackerCommon.getXml(requestBodys, map, dataList, isTag);
        }
        return PackerCommon.getXml(requestBodys, map, dataList, isTag);
    }

    public static String getFileContent(CodeLess codeLess, Map<String, String> map, List<Map<String, String>> dataList) {
        String filecontSplit = codeLess.getFilecontSplit();
        List<CodeLessRequestFileCont> fileConts = codeLess.getFileContBodys();
        StringBuilder builder = new StringBuilder();
        String fileHead = codeLess.getFileHead();
        if (StringUtils.isNotEmpty(fileHead)) {
            builder.append(fileHead).append("\r\n");
        }
        for (Map<String, String> mapEach : dataList) {
            for (CodeLessRequestFileCont codeLessRequestFileCont : fileConts) {
                String source = codeLessRequestFileCont.getEbgParamSource();
                if ("ebg_field".equals(source)) {
                    source = codeLessRequestFileCont.getEbgFieldType();
                }
                String value = PackerCommon.getXmlValue(source, mapEach, codeLessRequestFileCont.getEbgParam(), codeLessRequestFileCont.getExample(), map, codeLessRequestFileCont.getJudgingCondition());
                builder.append(value).append(filecontSplit);
            }
            builder.append("\r\n");
        }
        return builder.toString();
    }

    public static String getFileName(CodeLess codeLess, Map<String, String> map, List<Map<String, String>> dataList) {
        String filenameSplit = codeLess.getFilenameSplit();
        List<CodeLessRequestFileName> fileNameBodys = codeLess.getFileNameBodys();
        String filenameSuffix = codeLess.getFilenameSuffix();
        StringBuilder builder = new StringBuilder();
        Map<String, String> data = dataList.get(0);
        for (int i = 0; i < fileNameBodys.size(); ++i) {
            String value;
            CodeLessRequestFileName codeLessRequestFileName = fileNameBodys.get(i);
            String source = codeLessRequestFileName.getEbgParamSource();
            if ("ebg_field".equals(source)) {
                source = codeLessRequestFileName.getEbgFieldType();
            }
            if (StringUtils.isEmpty(value = PackerCommon.getXmlValue(source, data, codeLessRequestFileName.getEbgParam(), codeLessRequestFileName.getExample(), map, codeLessRequestFileName.getJudgingCondition()))) {
                logger.info("\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u53c2\u6570\u4e3a\uff1a" + source);
                throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u53c2\u6570\u4e3a\uff1a%s", (String)"PackerUtil_8", (String)"ebg-note-business", (Object[])new Object[0]), source));
            }
            builder.append(value);
            if (i == fileNameBodys.size() - 1) continue;
            builder.append(filenameSplit);
        }
        builder.append(filenameSuffix);
        return builder.toString();
    }

    public static String getXmlValue(String source, Map<String, String> data, String paramName, String defaultValue, Map<String, String> map, JudgingConditions judgingCondition) {
        String value = "";
        if ("NOTE_METADATA".equals(source)) {
            value = data.get(paramName);
        } else if ("default".equals(source)) {
            value = defaultValue;
        } else if ("BANK_LOGIN_CONFIG".equals(source)) {
            value = RequestContextUtils.getParameter().getBankParameter(paramName);
        } else if ("BANK_ACNT_CONFIG".equals(source)) {
            value = RequestContextUtils.getParameter().getBankParameter("accno_" + paramName);
        } else if ("judging_condition".equals(source)) {
            value = PackerCommon.getConditionValue(judgingCondition, data, map);
        } else {
            if ("error".equals(source)) {
                throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u5224\u65ad\u629b\u51fa\u5f02\u5e38%s", (String)"PackerUtil_9", (String)"ebg-note-business", (Object[])new Object[0]), paramName));
            }
            value = paramName.startsWith("util_") ? DataUtil.getValue(paramName) : map.get(paramName);
        }
        if (StringUtils.isEmpty(value)) {
            value = "";
        }
        return value;
    }

    public static String getConditionValue(JudgingConditions judgingCondition, Map<String, String> data, Map<String, String> map) {
        List<JudgingCondition1> judgingConditionBodyList = judgingCondition.getJudgingConditionList();
        if (judgingConditionBodyList == null || judgingConditionBodyList.size() < 1) {
            throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u7ed3\u6784\u5f02\u5e38\uff1a%1$s %2$s", (String)"PackerUtil_10", (String)"ebg-note-business", (Object[])new Object[0]), judgingCondition.getNumber(), judgingCondition.getName()));
        }
        String exp = "";
        for (JudgingCondition1 judgingCondition1 : judgingConditionBodyList) {
            List<JudgingConditionBody> judgingConditionBodies = judgingCondition1.getJudgingConditionBodys();
            if (judgingConditionBodyList == null || judgingConditionBodyList.size() < 1) {
                throw EBExceiptionUtil.serviceException(String.format(ResManager.loadKDString((String)"\u5224\u65ad\u6761\u4ef6\u7ed3\u6784\u5f02\u5e38\uff1a%s", (String)"PackerUtil_11", (String)"ebg-note-business", (Object[])new Object[0]), judgingCondition1.getEntryID()));
            }
            StringBuilder expression = new StringBuilder();
            Function s = null;
            Class<?> aClass = null;
            try {
                aClass = Class.forName("kd.ebg.egf.common.codeless.services.Function");
                s = (Function)aClass.newInstance();
            }
            catch (Exception e) {
                logger.error("error:", e);
            }
            for (int i = 0; i < judgingConditionBodies.size(); ++i) {
                JudgingConditionBody judgingConditionBody = judgingConditionBodies.get(i);
                String judgeSource = judgingConditionBody.getEbgParamSource();
                if ("ebg_field".equals(judgeSource)) {
                    judgeSource = judgingConditionBody.getEbgFieldType();
                }
                String paramName = judgingConditionBody.getEbgParam();
                String judgeValue = PackerCommon.getXmlValue(judgeSource, data, paramName, null, map, null);
                String filterCompare = judgingConditionBody.getFilterCompare();
                String targertValue = judgingConditionBody.getValue();
                String filterLink = judgingConditionBody.getFilterLink();
                if (i == judgingConditionBodies.size() - 1) {
                    filterLink = "";
                }
                Method declaredMethod = null;
                try {
                    declaredMethod = aClass.getDeclaredMethod(FuncNameRelection.getValue(filterCompare), new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    logger.error("error:", e);
                }
                try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
                    if (declaredMethod != null) {
                        String funcExpression = String.format("services.callBack('%1$s', '%2$s');", judgeValue, targertValue);
                        context.getBindings("js").putMember("services", (Object)s);
                        context.eval("js", (CharSequence)funcExpression);
                        Boolean tempResult = (Boolean)declaredMethod.invoke((Object)s, new Object[0]);
                        expression.append(tempResult.toString()).append(SPLIT).append(filterLink);
                        continue;
                    }
                }
                catch (Exception e) {
                    logger.error("error:", e);
                }
                targertValue = "\"" + targertValue + "\"";
                if (judgeValue != null) {
                    judgeValue = "\"" + judgeValue + "\"";
                }
                if (filterCompare.equals("is null")) {
                    filterCompare = "== null";
                }
                if (filterCompare.equals("=")) {
                    filterCompare = "==";
                }
                expression = expression.append(judgeValue).append(SPLIT).append(filterCompare).append(SPLIT).append(targertValue).append(SPLIT).append(filterLink);
                exp = expression.toString();
            }
            Boolean evaluation = null;
            try (Context context = Context.newBuilder((String[])new String[0]).allowAllAccess(true).build();){
                Value js = context.eval("js", (CharSequence)expression.toString());
                evaluation = js.asBoolean();
            }
            catch (Exception e) {
                logger.error(EBExceiptionUtil.stackTraceString(e.getStackTrace()));
            }
            if (evaluation == null) {
                return null;
            }
            if (!evaluation.equals(Boolean.TRUE)) continue;
            String source = judgingCondition1.getEbgParamSource();
            if ("ebg_field".equals(source)) {
                source = judgingCondition1.getEbgFieldType();
            }
            return PackerCommon.getXmlValue(source, data, judgingCondition1.getEbgParam(), judgingCondition1.getValue(), map, null);
        }
        JudgingConditionValue judgingConditionValue = judgingCondition.getNotValidValue();
        String source = judgingConditionValue.getEbgParamSource();
        if ("ebg_field".equals(source)) {
            source = judgingConditionValue.getEbgFieldType();
        } else if ("error".equals(source)) {
            logger.info("\u65e0\u5339\u914d\u6761\u4ef6\u4e3a\uff1a{}", (Object)exp);
        }
        String value = PackerCommon.getXmlValue(source, data, judgingConditionValue.getEbgParam(), judgingConditionValue.getValue(), map, null);
        return value;
    }

    /*
     * WARNING - void declaration
     */
    public static String getXml(List<CodeLessRequestBody> requestBodys, Map map, List<Map<String, String>> dataList, boolean isTag) {
        EBContext ebContext = EBContext.getContext();
        CodeLessRequestBody bodyroot = requestBodys.get(0);
        Element root = JDomUtils.createRoot(bodyroot.getParamName());
        List<CodeLessRequestBody> first = PackerCommon.getList(requestBodys, bodyroot.getEntryID());
        for (CodeLessRequestBody codeLessRequestBody : first) {
            String paramNode = codeLessRequestBody.getParamNode();
            Element element = root;
            if ("business_node".equals(paramNode)) {
                void var13_16;
                String bank = codeLessRequestBody.getParamName();
                String string = codeLessRequestBody.getEbgParamSource();
                if ("ebg_field".equals(string)) {
                    String string2 = codeLessRequestBody.getEbgFieldType();
                }
                String example = codeLessRequestBody.getExample();
                String bankValue = PackerCommon.getXmlValue((String)var13_16, dataList.get(0), codeLessRequestBody.getEbgParam(), example, map, codeLessRequestBody.getJudgingCondition());
                int must = codeLessRequestBody.getMust();
                if (must == 0 && StringUtils.isEmpty(bankValue)) continue;
                if (isTag) {
                    JDomExtUtils.addChildCDData(element, bank, bankValue);
                    continue;
                }
                JDomUtils.addChild(element, bank, bankValue);
                continue;
            }
            if ("repeat_node".equals(paramNode)) {
                for (Map map2 : dataList) {
                    element = JDomUtils.addChild(root, codeLessRequestBody.getParamName());
                    Long newPvalue = codeLessRequestBody.getEntryID();
                    PackerCommon.getAreaArrayByPAreaNo(requestBodys, element, newPvalue, map, dataList, map2, isTag);
                }
                continue;
            }
            element = JDomUtils.addChild(root, codeLessRequestBody.getParamName());
            Long newPvalue = codeLessRequestBody.getEntryID();
            PackerCommon.getAreaArrayByPAreaNo(requestBodys, element, newPvalue, map, dataList, dataList.get(0), isTag);
        }
        String root2String = JDomUtils.root2String(root, ebContext.getCharsetName());
        return root2String;
    }

    private static void getAreaArrayByPAreaNo(List<CodeLessRequestBody> requestBodys, Element element, Long PID, Map ebg, List<Map<String, String>> dataList, Map<String, String> eachMap, boolean isTag) {
        List<CodeLessRequestBody> resultList = PackerCommon.getList(requestBodys, PID);
        Element back = element;
        if (resultList != null && resultList.size() > 0) {
            for (CodeLessRequestBody codeLessRequestBody : resultList) {
                String paramNode = codeLessRequestBody.getParamNode();
                Long newPvalue = codeLessRequestBody.getEntryID();
                String bank = codeLessRequestBody.getParamName();
                String dataSorce = codeLessRequestBody.getEbgParamSource();
                if ("ebg_field".equals(dataSorce)) {
                    dataSorce = codeLessRequestBody.getEbgFieldType();
                }
                String example = codeLessRequestBody.getExample();
                if ("business_node".equals(paramNode)) {
                    String bankValue = PackerCommon.getXmlValue(dataSorce, eachMap, codeLessRequestBody.getEbgParam(), example, ebg, codeLessRequestBody.getJudgingCondition());
                    int must = codeLessRequestBody.getMust();
                    if (must != 0 || !StringUtils.isEmpty(bankValue)) {
                        if (isTag) {
                            JDomExtUtils.addChildCDData(element, bank, bankValue);
                        } else {
                            JDomUtils.addChild(element, bank, bankValue);
                        }
                    }
                    back = element;
                    PackerCommon.getAreaArrayByPAreaNo(requestBodys, back, newPvalue, ebg, dataList, eachMap, isTag);
                    continue;
                }
                if ("repeat_node".equals(paramNode)) {
                    for (Map<String, String> mapEach : dataList) {
                        back = JDomUtils.addChild(element, bank);
                        PackerCommon.getAreaArrayByPAreaNo(requestBodys, back, newPvalue, ebg, dataList, mapEach, isTag);
                    }
                    continue;
                }
                back = JDomUtils.addChild(element, bank);
                PackerCommon.getAreaArrayByPAreaNo(requestBodys, back, newPvalue, ebg, dataList, eachMap, isTag);
            }
        }
    }

    private static List<CodeLessRequestBody> getList(List<CodeLessRequestBody> requestBodys, Long PID) {
        ArrayList<CodeLessRequestBody> list = new ArrayList<CodeLessRequestBody>();
        for (CodeLessRequestBody entry : requestBodys) {
            if (!PID.equals(entry.getParentEntryID())) continue;
            list.add(entry);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public static String getJson(List<CodeLessRequestBody> requestBodys, Map map, List<Map<String, String>> dataList) {
        JSONObject root = new JSONObject();
        List<CodeLessRequestBody> first = PackerCommon.getList(requestBodys, 0L);
        for (CodeLessRequestBody codeLessRequestBody : first) {
            String paramNode = codeLessRequestBody.getParamNode();
            JSONObject element = root;
            if ("business_node".equals(paramNode)) {
                void var10_13;
                String bank = codeLessRequestBody.getParamName();
                String string = codeLessRequestBody.getEbgParamSource();
                if ("ebg_field".equals(string)) {
                    String string2 = codeLessRequestBody.getEbgFieldType();
                }
                String example = codeLessRequestBody.getExample();
                String bankValue = PackerCommon.getXmlValue((String)var10_13, dataList.get(0), codeLessRequestBody.getEbgParam(), example, map, codeLessRequestBody.getJudgingCondition());
                int must = codeLessRequestBody.getMust();
                if (must == 0 && StringUtils.isEmpty(bankValue)) continue;
                element.put(bank, (Object)bankValue);
                continue;
            }
            if ("repeat_node".equals(paramNode)) {
                for (Map map2 : dataList) {
                    JSONObject child = new JSONObject();
                    root.put(codeLessRequestBody.getParamName(), (Object)child);
                    element = child;
                    Long newPvalue = codeLessRequestBody.getEntryID();
                    PackerCommon.getAreaArrayByPAreaNoJson(requestBodys, element, newPvalue, map, dataList, map2);
                }
                continue;
            }
            JSONObject child = new JSONObject();
            root.put(codeLessRequestBody.getParamName(), (Object)child);
            element = child;
            Long l = codeLessRequestBody.getEntryID();
            PackerCommon.getAreaArrayByPAreaNoJson(requestBodys, element, l, map, dataList, dataList.get(0));
        }
        String root2String = root.toJSONString();
        return root2String;
    }

    private static void getAreaArrayByPAreaNoJson(List<CodeLessRequestBody> requestBodys, JSONObject element, Long PID, Map ebg, List<Map<String, String>> dataList, Map<String, String> eachMap) {
        List<CodeLessRequestBody> resultList = PackerCommon.getList(requestBodys, PID);
        JSONObject back = element;
        if (resultList != null && resultList.size() > 0) {
            for (CodeLessRequestBody codeLessRequestBody : resultList) {
                String paramNode = codeLessRequestBody.getParamNode();
                Long newPvalue = codeLessRequestBody.getEntryID();
                String bank = codeLessRequestBody.getParamName();
                String dataSorce = codeLessRequestBody.getEbgParamSource();
                if ("ebg_field".equals(dataSorce)) {
                    dataSorce = codeLessRequestBody.getEbgFieldType();
                }
                String example = codeLessRequestBody.getExample();
                if ("business_node".equals(paramNode)) {
                    String bankValue = PackerCommon.getXmlValue(dataSorce, eachMap, codeLessRequestBody.getEbgParam(), example, ebg, codeLessRequestBody.getJudgingCondition());
                    int must = codeLessRequestBody.getMust();
                    if (must != 0 || !StringUtils.isEmpty(bankValue)) {
                        element.put(bank, (Object)bankValue);
                    }
                    back = element;
                    PackerCommon.getAreaArrayByPAreaNoJson(requestBodys, back, newPvalue, ebg, dataList, eachMap);
                    continue;
                }
                if ("repeat_node".equals(paramNode)) {
                    JSONArray array = new JSONArray();
                    for (Map<String, String> mapEach : dataList) {
                        JSONObject child;
                        back = child = new JSONObject();
                        PackerCommon.getAreaArrayByPAreaNoJson(requestBodys, back, newPvalue, ebg, dataList, mapEach);
                        array.add((Object)child);
                    }
                    element.put(codeLessRequestBody.getParamName(), (Object)array);
                    continue;
                }
                JSONObject child = new JSONObject();
                element.put(codeLessRequestBody.getParamName(), (Object)child);
                back = child;
                PackerCommon.getAreaArrayByPAreaNoJson(requestBodys, back, newPvalue, ebg, dataList, eachMap);
            }
        }
    }

    public static String packerCommonByCodeless(List<Map<String, String>> dataList, Map<String, String> map, CodeLess codeLess) {
        EBContext context = EBContext.getContext();
        context.setCodeLess(codeLess);
        if ("xml".equals(codeLess.getContentType())) {
            return PackerCommon.packerXml(dataList, codeLess, map, false);
        }
        if ("json".equals(codeLess.getContentType())) {
            return PackerCommon.packerJson(dataList, codeLess, map);
        }
        return PackerCommon.packerXml(dataList, codeLess, map, true);
    }

    public static void changeContext(String structId, String bizType, String app) {
        logger.info("\u5f53\u524d\u63a5\u53e3structId\uff1a" + structId);
        EBContext context = EBContext.getContext();
        String bankVersion = context.getBankVersionID();
        CodeLess codeLess = CodeLessService.getInstance().getCodeLessByBankVersionIDAndInterfaceCodeAndApp(bankVersion, bizType, structId, app);
        context.setCodeLess(codeLess);
    }
}

