/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.egf.common.framework.communication;

import java.io.IOException;
import java.io.OutputStream;
import kd.ebg.egf.common.framework.communication.FilterConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;

public class FilterOutputStream
extends OutputStream {
    private OutputStream outputStream;
    private FilterConnection connection;

    public FilterOutputStream(OutputStream outputStream, FilterConnection connection) {
        this.outputStream = outputStream;
        this.connection = connection;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.connection.getConnection() instanceof TcpConnection) {
            ((TcpConnection)this.connection.getConnection()).shutdownOutput();
        } else {
            this.outputStream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.connection.beforeWrite(this.outputStream, b);
        this.outputStream.write(b);
        this.connection.afterWrite(this.outputStream, b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.connection.beforeWrite(this.outputStream, b);
        this.outputStream.write(b, off, len);
        this.connection.afterWrite(this.outputStream, b);
    }
}

